/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.config.ConfigPatternMatcher;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.matcher.LegacyMatchingPointConfigPatternMatcher;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class LegacyMatchingPointConfigPatternMatcherTest {
    @Test
    public void testNearCacheConfigWildcardMatchingPointStartsWith() {
        NearCacheConfig nearCacheConfig1 = new NearCacheConfig().setName("hazelcast.*");
        NearCacheConfig nearCacheConfig2 = new NearCacheConfig().setName("hazelcast.test.*");
        NearCacheConfig nearCacheConfig3 = new NearCacheConfig().setName("hazelcast.test.sub.*");
        ClientConfig config = new ClientConfig();
        config.setConfigPatternMatcher((ConfigPatternMatcher)new LegacyMatchingPointConfigPatternMatcher());
        config.addNearCacheConfig(nearCacheConfig1);
        config.addNearCacheConfig(nearCacheConfig2);
        config.addNearCacheConfig(nearCacheConfig3);
        Assert.assertEquals((Object)nearCacheConfig1, (Object)config.getNearCacheConfig("com.hazelcast.myNearCache"));
        Assert.assertEquals((Object)nearCacheConfig2, (Object)config.getNearCacheConfig("com.hazelcast.test.myNearCache"));
        Assert.assertEquals((Object)nearCacheConfig3, (Object)config.getNearCacheConfig("com.hazelcast.test.sub.myNearCache"));
    }

    @Test
    public void testNearCacheConfigWildcardMatchingPointEndsWith() {
        NearCacheConfig nearCacheConfig1 = new NearCacheConfig().setName("*.sub");
        NearCacheConfig nearCacheConfig2 = new NearCacheConfig().setName("*.test.sub");
        NearCacheConfig nearCacheConfig3 = new NearCacheConfig().setName("*.hazelcast.test.sub");
        ClientConfig config = new ClientConfig();
        config.setConfigPatternMatcher((ConfigPatternMatcher)new LegacyMatchingPointConfigPatternMatcher());
        config.addNearCacheConfig(nearCacheConfig1);
        config.addNearCacheConfig(nearCacheConfig2);
        config.addNearCacheConfig(nearCacheConfig3);
        Assert.assertEquals((Object)nearCacheConfig1, (Object)config.getNearCacheConfig("com.hazelFast.Fast.sub.myNearCache"));
        Assert.assertEquals((Object)nearCacheConfig2, (Object)config.getNearCacheConfig("com.hazelFast.test.sub.myNearCache"));
        Assert.assertEquals((Object)nearCacheConfig3, (Object)config.getNearCacheConfig("com.hazelcast.test.sub.myNearCache"));
    }
}

