/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.XmlClientConfigBuilderTest;
import com.hazelcast.config.ConfigurationException;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.XmlConfigImportVariableReplacementTest;
import com.hazelcast.config.replacer.EncryptionReplacer;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Properties;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class XmlClientConfigImportVariableReplacementTest
extends HazelcastTestSupport {
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    @Test(expected=InvalidConfigurationException.class)
    public void testImportElementOnlyAppersInTopLevel() throws Exception {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n   <network>\n        <import resource=\"\"/>\n   </network>\n</hazelcast-client>";
        XmlClientConfigBuilderTest.buildConfig(xml);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testHazelcastElementOnlyAppearsOnce() throws Exception {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n   <hazelcast-client>   </hazelcast-client></hazelcast-client>";
        XmlClientConfigBuilderTest.buildConfig(xml);
    }

    @Test
    public void readVariables() {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n<executor-pool-size>${executor.pool.size}</executor-pool-size></hazelcast-client>";
        ClientConfig config = XmlClientConfigBuilderTest.buildConfig(xml, "executor.pool.size", "40");
        Assert.assertEquals((long)40L, (long)config.getExecutorPoolSize());
    }

    @Test
    public void testImportConfigFromResourceVariables() throws IOException {
        File file = this.createConfigFile("foo", "bar");
        FileOutputStream os = new FileOutputStream(file);
        String networkConfig = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n<network>    <cluster-members>      <address>192.168.100.100</address>      <address>127.0.0.10</address>    </cluster-members>    <smart-routing>false</smart-routing>    <redo-operation>true</redo-operation>    <socket-interceptor enabled=\"true\">      <class-name>com.hazelcast.examples.MySocketInterceptor</class-name>      <properties>        <property name=\"foo\">bar</property>      </properties>    </socket-interceptor>  </network></hazelcast-client>";
        this.writeStringToStreamAndClose(os, networkConfig);
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n    <import resource=\"${config.location}\"/>\n</hazelcast-client>";
        ClientConfig config = XmlClientConfigBuilderTest.buildConfig(xml, "config.location", file.getAbsolutePath());
        Assert.assertFalse((boolean)config.getNetworkConfig().isSmartRouting());
        Assert.assertTrue((boolean)config.getNetworkConfig().isRedoOperation());
        XmlClientConfigImportVariableReplacementTest.assertContains((Collection)config.getNetworkConfig().getAddresses(), (Object)"192.168.100.100");
        XmlClientConfigImportVariableReplacementTest.assertContains((Collection)config.getNetworkConfig().getAddresses(), (Object)"127.0.0.10");
    }

    @Test
    public void testImportedConfigVariableReplacement() throws IOException {
        File file = this.createConfigFile("foo", "bar");
        FileOutputStream os = new FileOutputStream(file);
        String networkConfig = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n  <network>    <cluster-members>      <address>${ip.address}</address>    </cluster-members>  </network></hazelcast-client>";
        this.writeStringToStreamAndClose(os, networkConfig);
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n    <import resource=\"${config.location}\"/>\n</hazelcast-client>";
        Properties properties = new Properties();
        properties.setProperty("config.location", file.getAbsolutePath());
        properties.setProperty("ip.address", "192.168.5.5");
        ClientConfig config = XmlClientConfigBuilderTest.buildConfig(xml, properties);
        XmlClientConfigImportVariableReplacementTest.assertContains((Collection)config.getNetworkConfig().getAddresses(), (Object)"192.168.5.5");
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testTwoResourceCyclicImportThrowsException() throws Exception {
        File config1 = this.createConfigFile("hz1", ".xml");
        File config2 = this.createConfigFile("hz2", ".xml");
        FileOutputStream os1 = new FileOutputStream(config1);
        FileOutputStream os2 = new FileOutputStream(config2);
        String config1Xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n    <import resource=\"file:///" + config2.getAbsolutePath() + "\"/>\n" + "</hazelcast-client>";
        String config2Xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n    <import resource=\"file:///" + config1.getAbsolutePath() + "\"/>\n" + "</hazelcast-client>";
        this.writeStringToStreamAndClose(os1, config1Xml);
        this.writeStringToStreamAndClose(os2, config2Xml);
        XmlClientConfigBuilderTest.buildConfig(config1Xml);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testThreeResourceCyclicImportThrowsException() throws Exception {
        File config1 = this.createConfigFile("hz1", ".xml");
        File config2 = this.createConfigFile("hz2", ".xml");
        File config3 = this.createConfigFile("hz3", ".xml");
        FileOutputStream os1 = new FileOutputStream(config1);
        FileOutputStream os2 = new FileOutputStream(config2);
        FileOutputStream os3 = new FileOutputStream(config2);
        String config1Xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n    <import resource=\"file:///" + config2.getAbsolutePath() + "\"/>\n" + "</hazelcast-client>";
        String config2Xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n    <import resource=\"file:///" + config3.getAbsolutePath() + "\"/>\n" + "</hazelcast-client>";
        String config3Xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n    <import resource=\"file:///" + config1.getAbsolutePath() + "\"/>\n" + "</hazelcast-client>";
        this.writeStringToStreamAndClose(os1, config1Xml);
        this.writeStringToStreamAndClose(os2, config2Xml);
        this.writeStringToStreamAndClose(os3, config3Xml);
        XmlClientConfigBuilderTest.buildConfig(config1Xml);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testImportEmptyResourceContent() throws Exception {
        File config = this.createConfigFile("hz1", ".xml");
        FileOutputStream os = new FileOutputStream(config);
        String configXml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n    <import resource=\"file:///" + config.getAbsolutePath() + "\"/>\n" + "</hazelcast-client>";
        this.writeStringToStreamAndClose(os, "");
        XmlClientConfigBuilderTest.buildConfig(configXml);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testImportEmptyResourceThrowsException() throws Exception {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n    <import resource=\"\"/>\n</hazelcast-client>";
        XmlClientConfigBuilderTest.buildConfig(xml);
    }

    @Test(expected=InvalidConfigurationException.class)
    public void testImportNotExistingResourceThrowsException() throws Exception {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n    <import resource=\"notexisting.xml\"/>\n</hazelcast-client>";
        XmlClientConfigBuilderTest.buildConfig(xml);
    }

    @Test
    public void testReplacers() throws Exception {
        File passwordFile = this.tempFolder.newFile(((Object)((Object)this)).getClass().getSimpleName() + ".pwd");
        PrintWriter out = new PrintWriter(passwordFile);
        try {
            out.print("This is a password");
        }
        finally {
            IOUtil.closeResource((Closeable)out);
        }
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n    <config-replacers>\n        <replacer class-name='" + EncryptionReplacer.class.getName() + "'>\n            <properties>\n                <property name='passwordFile'>" + passwordFile.getAbsolutePath() + "</property>\n                <property name='passwordUserProperties'>false</property>\n                <property name='keyLengthBits'>64</property>\n                <property name='saltLengthBytes'>8</property>\n                <property name='cipherAlgorithm'>DES</property>\n                <property name='secretKeyFactoryAlgorithm'>PBKDF2WithHmacSHA1</property>\n                <property name='secretKeyAlgorithm'>DES</property>\n            </properties>\n        </replacer>\n        <replacer class-name='" + XmlConfigImportVariableReplacementTest.IdentityReplacer.class.getName() + "'/>\n    </config-replacers>\n    <group>\n        <name>${java.version} $ID{dev}</name>\n        <password>$ENC{7JX2r/8qVVw=:10000:Jk4IPtor5n/vCb+H8lYS6tPZOlCZMtZv}</password>\n    </group>\n" + "</hazelcast-client>";
        GroupConfig groupConfig = XmlClientConfigBuilderTest.buildConfig(xml, System.getProperties()).getGroupConfig();
        Assert.assertEquals((Object)(System.getProperty("java.version") + " dev"), (Object)groupConfig.getName());
        Assert.assertEquals((Object)"My very secret secret", (Object)groupConfig.getPassword());
    }

    @Test(expected=ConfigurationException.class)
    public void testMissingReplacement() throws Exception {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n    <config-replacers>\n        <replacer class-name='" + EncryptionReplacer.class.getName() + "'/>\n    </config-replacers>\n    <group>\n        <name>$ENC{7JX2r/8qVVw=:10000:Jk4IPtor5n/vCb+H8lYS6tPZOlCZMtZv}</name>\n    </group>\n" + "</hazelcast-client>";
        XmlClientConfigBuilderTest.buildConfig(xml, System.getProperties());
    }

    @Test
    public void testReplacerProperties() throws Exception {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n    <config-replacers fail-if-value-missing='false'>\n        <replacer class-name='" + XmlConfigImportVariableReplacementTest.TestReplacer.class.getName() + "'>\n            <properties>\n                <property name='p1'>a property</property>\n                <property name='p2'/>\n                <property name='p3'>another property</property>\n                <property name='p4'>&lt;test/&gt;</property>\n            </properties>\n        </replacer>\n    </config-replacers>\n    <group>\n        <name>$T{p1} $T{p2} $T{p3} $T{p4} $T{p5}</name>\n    </group>\n" + "</hazelcast-client>";
        GroupConfig groupConfig = XmlClientConfigBuilderTest.buildConfig(xml, System.getProperties()).getGroupConfig();
        Assert.assertEquals((Object)"a property  another property <test/> $T{p5}", (Object)groupConfig.getName());
    }

    @Test
    public void testNoConfigReplacersMissingProperties() throws Exception {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n    <group>\n        <name>${noSuchPropertyAvailable}</name>\n    </group>\n</hazelcast-client>";
        GroupConfig groupConfig = XmlClientConfigBuilderTest.buildConfig(xml, System.getProperties()).getGroupConfig();
        Assert.assertEquals((Object)"${noSuchPropertyAvailable}", (Object)groupConfig.getName());
    }

    @Test
    public void testImportGroupConfigFromClassPath() throws Exception {
        String xml = "<hazelcast-client xmlns=\"http://www.hazelcast.com/schema/client-config\">\n    <import resource=\"classpath:hazelcast-client-c1.xml\"/>\n</hazelcast-client>";
        ClientConfig config = XmlClientConfigBuilderTest.buildConfig(xml);
        GroupConfig groupConfig = config.getGroupConfig();
        Assert.assertEquals((Object)"cluster1", (Object)groupConfig.getName());
        Assert.assertEquals((Object)"cluster1pass", (Object)groupConfig.getPassword());
    }

    private File createConfigFile(String filename, String suffix) throws IOException {
        File file = File.createTempFile(filename, suffix);
        file.setWritable(true);
        file.deleteOnExit();
        return file;
    }

    private void writeStringToStreamAndClose(FileOutputStream os, String string) throws IOException {
        os.write(string.getBytes());
        os.flush();
        IOUtil.closeResource((Closeable)os);
    }
}

