/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.connectionstrategy;

import com.hazelcast.client.config.ClientClasspathXmlConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class})
public class ConfiguredBehaviourTestXmlConfig
extends ClientTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private static final CountDownLatch asyncStartFromXmlLatch = new CountDownLatch(1);

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testAsyncStartTrueXmlConfig() {
        ClientClasspathXmlConfig clientConfig = new ClientClasspathXmlConfig("hazelcast-client-connection-strategy-asyncStart-true.xml");
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient((ClientConfig)clientConfig);
        Assert.assertTrue((boolean)client.getLifecycleService().isRunning());
        this.hazelcastFactory.newHazelcastInstance();
        ConfiguredBehaviourTestXmlConfig.assertOpenEventually((CountDownLatch)asyncStartFromXmlLatch);
        client.getMap(ConfiguredBehaviourTestXmlConfig.randomMapName());
    }

    @Test
    public void testReconnectModeASYNCSingleMemberStartLateXmlConfig() {
        final CountDownLatch reconnectedLatch = new CountDownLatch(1);
        HazelcastInstance hazelcastInstance = this.hazelcastFactory.newHazelcastInstance();
        ClientClasspathXmlConfig clientConfig = new ClientClasspathXmlConfig("hazelcast-client-connection-strategy-asyncReconnect.xml");
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient((ClientConfig)clientConfig);
        Assert.assertTrue((boolean)client.getLifecycleService().isRunning());
        hazelcastInstance.shutdown();
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (event.getState().equals((Object)LifecycleEvent.LifecycleState.CLIENT_CONNECTED)) {
                    reconnectedLatch.countDown();
                }
            }
        });
        this.hazelcastFactory.newHazelcastInstance();
        ConfiguredBehaviourTestXmlConfig.assertOpenEventually((CountDownLatch)reconnectedLatch);
        client.getMap(ConfiguredBehaviourTestXmlConfig.randomMapName());
    }

    private static class AsyncStartListener
    implements LifecycleListener {
        private AsyncStartListener() {
        }

        public void stateChanged(LifecycleEvent event) {
            if (event.getState().equals((Object)LifecycleEvent.LifecycleState.CLIENT_CONNECTED)) {
                asyncStartFromXmlLatch.countDown();
            }
        }
    }
}

