/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.countdownlatch;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICountDownLatch;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientCountDownLatchTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private ICountDownLatch l;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        this.l = client.getCountDownLatch(ClientCountDownLatchTest.randomString());
    }

    @Test
    public void testLatch() throws Exception {
        Assert.assertTrue((boolean)this.l.trySetCount(20));
        Assert.assertFalse((boolean)this.l.trySetCount(10));
        Assert.assertEquals((long)20L, (long)this.l.getCount());
        new Thread(){

            @Override
            public void run() {
                for (int i = 0; i < 20; ++i) {
                    ClientCountDownLatchTest.this.l.countDown();
                    try {
                        Thread.sleep(60L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }.start();
        Assert.assertFalse((boolean)this.l.await(1L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)this.l.await(5L, TimeUnit.SECONDS));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testTrySetCount_whenArgumentNegative() {
        this.l.trySetCount(-20);
    }

    @Test
    public void testTrySetCount_whenCountIsNotZero() {
        this.l.trySetCount(10);
        Assert.assertFalse((boolean)this.l.trySetCount(20));
        Assert.assertFalse((boolean)this.l.trySetCount(0));
        Assert.assertEquals((long)10L, (long)this.l.getCount());
    }
}

