/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.discovery;

import com.hazelcast.aws.AwsDiscoveryStrategyFactory;
import com.hazelcast.aws.AwsProperties;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.ClientLoggingService;
import com.hazelcast.client.spi.impl.AwsAddressProvider;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.GroupConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.discovery.DiscoveryStrategyFactory;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.JenkinsDetector;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.SlowTest;
import com.hazelcast.util.CollectionUtil;
import java.util.Collection;
import java.util.HashMap;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={SlowTest.class, ParallelTest.class})
public class AwsCloudDiscoveryTest {
    private static final String ACCESS_KEY = AwsProperties.ACCESS_KEY.getDefinition().key();
    private static final String SECRET_KEY = AwsProperties.SECRET_KEY.getDefinition().key();
    private static final String AWS_TEST_TAG = "aws-test-tag";
    private static final String AWS_TEST_TAG_VALUE = "aws-tag-value-1";

    @Test
    public void testAwsClient_MemberNonDefaultPortConfig() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put(AwsProperties.PORT.getDefinition().key(), "60000");
        props.put(ACCESS_KEY, System.getenv("AWS_ACCESS_KEY_ID"));
        props.put(SECRET_KEY, System.getenv("AWS_SECRET_ACCESS_KEY"));
        props.put(AwsProperties.TAG_KEY.getDefinition().key(), AWS_TEST_TAG);
        props.put(AwsProperties.TAG_VALUE.getDefinition().key(), AWS_TEST_TAG_VALUE);
        props.put(AwsProperties.CONNECTION_TIMEOUT_SECONDS.getDefinition().key(), "10");
        if (JenkinsDetector.isOnJenkins()) {
            Assert.assertNotNull((String)"AWS_ACCESS_KEY_ID is not set", props.get(ACCESS_KEY));
            Assert.assertNotNull((String)"AWS_SECRET_ACCESS_KEY is not set", props.get(SECRET_KEY));
        } else {
            Assume.assumeThat((String)"AWS_ACCESS_KEY_ID is not set", props.get(ACCESS_KEY), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Assume.assumeThat((String)"AWS_SECRET_ACCESS_KEY is not set", props.get(SECRET_KEY), (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        }
        ClientConfig config = new ClientConfig();
        config.getNetworkConfig().getDiscoveryConfig().addDiscoveryStrategyConfig(new DiscoveryStrategyConfig((DiscoveryStrategyFactory)new AwsDiscoveryStrategyFactory(), props));
        config.setProperty(ClientProperty.DISCOVERY_SPI_ENABLED.getName(), "true");
        config.setProperty(ClientProperty.DISCOVERY_SPI_PUBLIC_IP_ENABLED.getName(), "true");
        HazelcastInstance client = HazelcastClient.newHazelcastClient((ClientConfig)config);
        IMap map = client.getMap("MyMap");
        map.put((Object)1, (Object)5);
        Assert.assertEquals((Object)5, (Object)map.get((Object)1));
    }

    @Test
    public void testAwsAddressProvider() {
        String awsAccessKeyId = System.getenv("AWS_ACCESS_KEY_ID");
        String awsSecretAccessKey = System.getenv("AWS_SECRET_ACCESS_KEY");
        String instancePrivateIp = System.getenv("HZ_TEST_AWS_INSTANCE_PRIVATE_IP");
        ClientAwsConfig clientAwsConfig = new ClientAwsConfig();
        if (JenkinsDetector.isOnJenkins()) {
            Assert.assertNotNull((String)"AWS_ACCESS_KEY_ID is not set", (Object)awsAccessKeyId);
            Assert.assertNotNull((String)"AWS_SECRET_ACCESS_KEY is not set", (Object)awsSecretAccessKey);
            Assert.assertNotNull((String)"HZ_TEST_AWS_INSTANCE_PRIVATE_IP is not set", (Object)instancePrivateIp);
            clientAwsConfig.setInsideAws(true);
        } else {
            Assume.assumeThat((String)"AWS_ACCESS_KEY_ID is not set", (Object)awsAccessKeyId, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Assume.assumeThat((String)"AWS_SECRET_ACCESS_KEY is not set", (Object)awsSecretAccessKey, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            Assume.assumeThat((String)"HZ_TEST_AWS_INSTANCE_PRIVATE_IP is not set", (Object)instancePrivateIp, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
            clientAwsConfig.setInsideAws(false);
        }
        clientAwsConfig.setEnabled(true).setAccessKey(awsAccessKeyId).setSecretKey(awsSecretAccessKey).setTagKey(AWS_TEST_TAG).setTagValue(AWS_TEST_TAG_VALUE);
        ClientConfig clientConfig = new ClientConfig();
        String instanceName = clientConfig.getInstanceName() != null ? clientConfig.getInstanceName() : "hz.client_testAwsAddressProvider";
        GroupConfig groupConfig = clientConfig.getGroupConfig();
        String loggingType = clientConfig.getProperty(GroupProperty.LOGGING_TYPE.getName());
        ClientLoggingService loggingService = new ClientLoggingService(groupConfig.getName(), loggingType, BuildInfoProvider.getBuildInfo(), instanceName);
        AwsAddressProvider awsAddressProvider = new AwsAddressProvider(clientAwsConfig, (LoggingService)loggingService);
        Collection addresses = awsAddressProvider.loadAddresses();
        Assert.assertTrue((String)"Expected non-empty addresses from AwsAddressProvider.loadAddresses()", (boolean)CollectionUtil.isNotEmpty((Collection)addresses));
        Assert.assertEquals((Object)instancePrivateIp, (Object)((Address)addresses.iterator().next()).getHost());
    }
}

