/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.executor;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.executor.tasks.CancellationAwareTask;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.Member;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
@Ignore
public class ClientExecutorServiceCancelTest
extends HazelcastTestSupport {
    public static final int SLEEP_TIME = 1000000;
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance server1;
    private HazelcastInstance server2;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        this.server1 = this.hazelcastFactory.newHazelcastInstance();
        this.server2 = this.hazelcastFactory.newHazelcastInstance();
    }

    private HazelcastInstance createClient(boolean smartRouting) {
        ClientConfig config = new ClientConfig();
        config.getNetworkConfig().setSmartRouting(smartRouting);
        return this.hazelcastFactory.newHazelcastClient(config);
    }

    @Test(expected=CancellationException.class)
    public void testCancel_submitRandom_withSmartRouting() throws ExecutionException, InterruptedException {
        this.testCancel_submitRandom(true);
    }

    @Test(expected=CancellationException.class)
    public void testCancel_submitRandom_withDummyRouting() throws ExecutionException, InterruptedException {
        this.testCancel_submitRandom(false);
    }

    private void testCancel_submitRandom(boolean smartRouting) throws ExecutionException, InterruptedException {
        HazelcastInstance client = this.createClient(smartRouting);
        IExecutorService executorService = client.getExecutorService(ClientExecutorServiceCancelTest.randomString());
        Future future = executorService.submit((Callable)new CancellationAwareTask(1000000L));
        boolean cancelled = future.cancel(true);
        Assert.assertTrue((boolean)cancelled);
        future.get();
    }

    @Test(expected=CancellationException.class)
    @Ignore
    public void testCancel_submitToMember1_withSmartRouting() throws ExecutionException, InterruptedException {
        this.testCancel_submitToMember(true, this.server1.getCluster().getLocalMember());
    }

    @Test(expected=CancellationException.class)
    @Ignore
    public void testCancel_submitToMember2_withSmartRouting() throws ExecutionException, InterruptedException {
        this.testCancel_submitToMember(true, this.server2.getCluster().getLocalMember());
    }

    @Test(expected=CancellationException.class)
    @Ignore
    public void testCancel_submitToMember1_withDummyRouting() throws ExecutionException, InterruptedException {
        this.testCancel_submitToMember(false, this.server1.getCluster().getLocalMember());
    }

    @Test(expected=CancellationException.class)
    @Ignore
    public void testCancel_submitToMember2_withDummyRouting() throws ExecutionException, InterruptedException {
        this.testCancel_submitToMember(false, this.server2.getCluster().getLocalMember());
    }

    private void testCancel_submitToMember(boolean smartRouting, Member member) throws ExecutionException, InterruptedException {
        HazelcastInstance client = this.createClient(smartRouting);
        IExecutorService executorService = client.getExecutorService(ClientExecutorServiceCancelTest.randomString());
        Future future = executorService.submitToMember((Callable)new CancellationAwareTask(1000000L), member);
        boolean cancelled = future.cancel(true);
        Assert.assertTrue((boolean)cancelled);
        future.get();
    }

    @Test(expected=CancellationException.class)
    public void testCancel_submitToKeyOwner_withSmartRouting() throws ExecutionException, InterruptedException {
        this.testCancel_submitToKeyOwner(true);
    }

    @Test(expected=CancellationException.class)
    public void testCancel_submitToKeyOwner_withDummyRouting() throws ExecutionException, InterruptedException {
        this.testCancel_submitToKeyOwner(false);
    }

    private void testCancel_submitToKeyOwner(boolean smartRouting) throws ExecutionException, InterruptedException {
        HazelcastInstance client = this.createClient(smartRouting);
        IExecutorService executorService = client.getExecutorService(ClientExecutorServiceCancelTest.randomString());
        Future future = executorService.submitToKeyOwner((Callable)new CancellationAwareTask(1000000L), (Object)ClientExecutorServiceCancelTest.randomString());
        boolean cancelled = future.cancel(true);
        Assert.assertTrue((boolean)cancelled);
        future.get();
    }
}

