/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.executor;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.NightlyTest;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={NightlyTest.class})
public class ExecutionDelayTest
extends HazelcastTestSupport {
    private static final int CLUSTER_SIZE = 3;
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private final List<HazelcastInstance> instances = new ArrayList<HazelcastInstance>(3);
    private TestHazelcastFactory hazelcastFactory;

    @After
    public void tearDown() {
        this.hazelcastFactory.shutdownAll();
    }

    @Before
    public void setup() throws IOException {
        this.hazelcastFactory = new TestHazelcastFactory();
        for (int i = 0; i < 3; ++i) {
            this.instances.add(this.hazelcastFactory.newHazelcastInstance());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecutorRetriesTask_whenOneNodeTerminates() throws InterruptedException, ExecutionException {
        int taskCount = 20;
        ScheduledExecutorService ex = Executors.newSingleThreadScheduledExecutor();
        try {
            ex.schedule(new Runnable(){

                @Override
                public void run() {
                    ((HazelcastInstance)ExecutionDelayTest.this.instances.get(1)).getLifecycleService().terminate();
                }
            }, 1000L, TimeUnit.MILLISECONDS);
            Task task = new Task();
            this.runClient(task, 20);
            ExecutionDelayTest.assertTrueEventually((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    int taskExecutions = COUNTER.get();
                    Assert.assertTrue((taskExecutions >= 20 ? 1 : 0) != 0);
                }
            });
        }
        finally {
            ex.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExecutorRetriesTask_whenOneNodeShutdowns() throws InterruptedException, ExecutionException {
        int taskCount = 20;
        ScheduledExecutorService ex = Executors.newSingleThreadScheduledExecutor();
        try {
            ex.schedule(new Runnable(){

                @Override
                public void run() {
                    ((HazelcastInstance)ExecutionDelayTest.this.instances.get(1)).shutdown();
                }
            }, 1000L, TimeUnit.MILLISECONDS);
            Task task = new Task();
            this.runClient(task, 20);
            ExecutionDelayTest.assertTrueEventually((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    int taskExecutions = COUNTER.get();
                    Assert.assertTrue((taskExecutions >= 20 ? 1 : 0) != 0);
                }
            });
        }
        finally {
            ex.shutdown();
        }
    }

    private void runClient(Task task, int executions) throws InterruptedException, ExecutionException {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setRedoOperation(true);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        IExecutorService executor = client.getExecutorService("executor");
        for (int i = 0; i < executions; ++i) {
            Future future = executor.submitToKeyOwner((Callable)task, (Object)i);
            future.get();
            Thread.sleep(100L);
        }
    }

    public static class Task
    implements Callable,
    Serializable {
        public Object call() throws Exception {
            COUNTER.incrementAndGet();
            return null;
        }

        public String toString() {
            return "Task{}";
        }
    }
}

