/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.flakeidgen.impl;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.instance.MemberImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class FlakeIdGenerator_NodeIdOverflowIntegrationTest {
    private static final ILogger LOGGER = Logger.getLogger(FlakeIdGenerator_NodeIdOverflowIntegrationTest.class);
    @Rule
    public ExpectedException exception = ExpectedException.none();
    private TestHazelcastFactory factory = new TestHazelcastFactory();

    @After
    public void after() {
        this.factory.shutdownAll();
    }

    @Test
    public void when_memberOutOfRangeNodeId_then_theOtherMemberUsed() throws Exception {
        HazelcastInstance instance1 = this.factory.newHazelcastInstance();
        HazelcastInstance instance2 = this.factory.newHazelcastInstance();
        this.assignOverflowedNodeId(instance2);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setSmartRouting(false);
        for (int i = 0; i < 10; ++i) {
            LOGGER.info("Creating client " + i);
            HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
            FlakeIdGenerator gen = client.getFlakeIdGenerator("gen");
            for (int j = 0; j < 100; ++j) {
                gen.newId();
            }
        }
    }

    @Test
    public void when_allMembersOutOfRangeNodeId_then_error() {
        HazelcastInstance instance1 = this.factory.newHazelcastInstance();
        HazelcastInstance instance2 = this.factory.newHazelcastInstance();
        this.assignOverflowedNodeId(instance1);
        this.assignOverflowedNodeId(instance2);
        HazelcastInstance client = this.factory.newHazelcastClient();
        FlakeIdGenerator gen = client.getFlakeIdGenerator("gen");
        this.exception.expect(HazelcastException.class);
        this.exception.expectMessage("All members have node ID out of range");
        gen.newId();
    }

    private void assignOverflowedNodeId(HazelcastInstance instance2) {
        MemberImpl member = (MemberImpl)instance2.getCluster().getLocalMember();
        member.setMemberListJoinVersion(100000);
    }
}

