/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.internal.diagnostics;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.internal.diagnostics.AbstractDiagnosticsPluginTest;
import com.hazelcast.internal.diagnostics.DiagnosticsLogWriter;
import com.hazelcast.internal.diagnostics.SystemLogPlugin;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class SystemLogPluginConnectionTest
extends AbstractDiagnosticsPluginTest {
    private TestHazelcastFactory hzFactory;
    private SystemLogPlugin plugin;

    @Before
    public void setUp() {
        Config config = new Config();
        config.setProperty(SystemLogPlugin.LOG_PARTITIONS.getName(), "true");
        this.hzFactory = new TestHazelcastFactory();
        HazelcastInstance hz = this.hzFactory.newHazelcastInstance(config);
        this.plugin = new SystemLogPlugin(SystemLogPluginConnectionTest.getNodeEngineImpl((HazelcastInstance)hz));
        this.plugin.onStart();
    }

    @After
    public void tearDown() {
        this.hzFactory.terminateAll();
    }

    @Test
    public void testConnection() {
        HazelcastInstance instance = this.hzFactory.newHazelcastClient();
        SystemLogPluginConnectionTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                SystemLogPluginConnectionTest.this.plugin.run((DiagnosticsLogWriter)SystemLogPluginConnectionTest.this.logWriter);
                SystemLogPluginConnectionTest.this.assertContains("ConnectionAdded");
            }
        });
        instance.shutdown();
        SystemLogPluginConnectionTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                SystemLogPluginConnectionTest.this.plugin.run((DiagnosticsLogWriter)SystemLogPluginConnectionTest.this.logWriter);
                SystemLogPluginConnectionTest.this.assertContains("ConnectionRemoved");
            }
        });
    }
}

