/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.io;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.SlowTest;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={SlowTest.class})
public class ClientExecutionPoolSizeLowTest {
    static final int COUNT = 1000;
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance server1;
    private HazelcastInstance server2;
    private IMap map;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() throws IOException {
        this.server1 = this.hazelcastFactory.newHazelcastInstance();
        this.server2 = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setExecutorPoolSize(1);
        clientConfig.getNetworkConfig().setRedoOperation(true);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        this.map = client.getMap(HazelcastTestSupport.randomString());
    }

    @Test
    public void testNodeTerminate() throws InterruptedException, ExecutionException {
        for (int i = 0; i < 1000; ++i) {
            this.map.put((Object)i, (Object)i);
            if (i != 500) continue;
            this.server2.getLifecycleService().terminate();
        }
        Assert.assertEquals((long)1000L, (long)this.map.size());
    }

    @Test
    public void testOwnerNodeTerminate() throws InterruptedException, ExecutionException {
        for (int i = 0; i < 1000; ++i) {
            this.map.put((Object)i, (Object)i);
            if (i != 500) continue;
            this.server1.getLifecycleService().terminate();
        }
        Assert.assertEquals((long)1000L, (long)this.map.size());
    }

    @Test
    public void testNodeTerminateWithAsyncOperations() throws InterruptedException, ExecutionException {
        for (int i = 0; i < 1000; ++i) {
            this.map.putAsync((Object)i, (Object)i);
            if (i != 500) continue;
            this.server2.getLifecycleService().terminate();
        }
        HazelcastTestSupport.assertSizeEventually((int)1000, (Map)this.map);
    }

    @Test
    public void testOwnerNodeTerminateWithAsyncOperations() throws InterruptedException, ExecutionException {
        for (int i = 0; i < 1000; ++i) {
            this.map.putAsync((Object)i, (Object)i);
            if (i != 500) continue;
            this.server1.getLifecycleService().terminate();
        }
        HazelcastTestSupport.assertSizeEventually((int)1000, (Map)this.map);
    }
}

