/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.listeners.leak;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.listeners.leak.ListenerLeakTestSupport;
import com.hazelcast.client.spi.impl.listener.ClientEventRegistration;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IList;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.ISet;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.ItemListener;
import com.hazelcast.core.MessageListener;
import com.hazelcast.core.MultiMap;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.instance.Node;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.map.listener.MapPartitionLostListener;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ListenerLeakTestNonSmartRouting
extends ListenerLeakTestSupport {
    private HazelcastInstance newHazelcastClient() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setSmartRouting(false);
        return this.hazelcastFactory.newHazelcastClient(clientConfig);
    }

    @Test
    public void testMapEntryListeners() {
        Collection<Node> nodes = this.createNodes();
        HazelcastInstance client = this.newHazelcastClient();
        IMap map = client.getMap(ListenerLeakTestNonSmartRouting.randomString());
        String id = map.addEntryListener((MapListener)Mockito.mock(MapListener.class), false);
        Collection<ClientEventRegistration> registrations = this.getClientEventRegistrations(client, id);
        Assert.assertTrue((boolean)map.removeEntryListener(id));
        this.assertNoLeftOver(nodes, client, id, registrations);
    }

    @Test
    public void testMapPartitionLostListeners() {
        Collection<Node> nodes = this.createNodes();
        HazelcastInstance client = this.newHazelcastClient();
        IMap map = client.getMap(ListenerLeakTestNonSmartRouting.randomString());
        String id = map.addPartitionLostListener((MapPartitionLostListener)Mockito.mock(MapPartitionLostListener.class));
        Collection<ClientEventRegistration> registrations = this.getClientEventRegistrations(client, id);
        Assert.assertTrue((boolean)map.removePartitionLostListener(id));
        this.assertNoLeftOver(nodes, client, id, registrations);
    }

    @Test
    public void testMultiMapEntryListeners() {
        Collection<Node> nodes = this.createNodes();
        HazelcastInstance client = this.newHazelcastClient();
        MultiMap multiMap = client.getMultiMap(ListenerLeakTestNonSmartRouting.randomString());
        String id = multiMap.addEntryListener((EntryListener)Mockito.mock(EntryListener.class), false);
        Collection<ClientEventRegistration> registrations = this.getClientEventRegistrations(client, id);
        Assert.assertTrue((boolean)multiMap.removeEntryListener(id));
        this.assertNoLeftOver(nodes, client, id, registrations);
    }

    @Test
    public void testListListeners() {
        Collection<Node> nodes = this.createNodes();
        HazelcastInstance client = this.newHazelcastClient();
        IList list = client.getList(ListenerLeakTestNonSmartRouting.randomString());
        String id = list.addItemListener((ItemListener)Mockito.mock(ItemListener.class), false);
        Collection<ClientEventRegistration> registrations = this.getClientEventRegistrations(client, id);
        Assert.assertTrue((boolean)list.removeItemListener(id));
        this.assertNoLeftOver(nodes, client, id, registrations);
    }

    @Test
    public void testSetListeners() {
        Collection<Node> nodes = this.createNodes();
        HazelcastInstance client = this.newHazelcastClient();
        ISet set = client.getSet(ListenerLeakTestNonSmartRouting.randomString());
        String id = set.addItemListener((ItemListener)Mockito.mock(ItemListener.class), false);
        Collection<ClientEventRegistration> registrations = this.getClientEventRegistrations(client, id);
        Assert.assertTrue((boolean)set.removeItemListener(id));
        this.assertNoLeftOver(nodes, client, id, registrations);
    }

    @Test
    public void testQueueListeners() {
        Collection<Node> nodes = this.createNodes();
        HazelcastInstance client = this.newHazelcastClient();
        IQueue queue = client.getQueue(ListenerLeakTestNonSmartRouting.randomString());
        String id = queue.addItemListener((ItemListener)Mockito.mock(ItemListener.class), false);
        Collection<ClientEventRegistration> registrations = this.getClientEventRegistrations(client, id);
        Assert.assertTrue((boolean)queue.removeItemListener(id));
        this.assertNoLeftOver(nodes, client, id, registrations);
    }

    @Test
    public void testReplicatedMapListeners() {
        Collection<Node> nodes = this.createNodes();
        HazelcastInstance client = this.newHazelcastClient();
        ReplicatedMap replicatedMap = client.getReplicatedMap(ListenerLeakTestNonSmartRouting.randomString());
        String id = replicatedMap.addEntryListener((EntryListener)Mockito.mock(EntryListener.class));
        Collection<ClientEventRegistration> registrations = this.getClientEventRegistrations(client, id);
        Assert.assertTrue((boolean)replicatedMap.removeEntryListener(id));
        this.assertNoLeftOver(nodes, client, id, registrations);
    }

    @Test
    public void testDistributedObjectListeners() {
        Collection<Node> nodes = this.createNodes();
        HazelcastInstance client = this.newHazelcastClient();
        String id = client.addDistributedObjectListener((DistributedObjectListener)Mockito.mock(DistributedObjectListener.class));
        Collection<ClientEventRegistration> registrations = this.getClientEventRegistrations(client, id);
        Assert.assertTrue((boolean)client.removeDistributedObjectListener(id));
        this.assertNoLeftOver(nodes, client, id, registrations);
    }

    @Test
    public void testTopicMessageListener() {
        Collection<Node> nodes = this.createNodes();
        HazelcastInstance client = this.newHazelcastClient();
        ITopic topic = client.getTopic(ListenerLeakTestNonSmartRouting.randomString());
        String id = topic.addMessageListener((MessageListener)Mockito.mock(MessageListener.class));
        Collection<ClientEventRegistration> registrations = this.getClientEventRegistrations(client, id);
        Assert.assertTrue((boolean)topic.removeMessageListener(id));
        this.assertNoLeftOver(nodes, client, id, registrations);
    }
}

