/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapStore;
import com.hazelcast.map.impl.mapstore.AbstractMapStoreTest;
import com.hazelcast.map.impl.mapstore.MapLoaderTest;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.TestCollectionUtils;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapLoadAllTest
extends AbstractMapStoreTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testGetMap_issue_3031() throws Exception {
        int itemCount = 1000;
        String mapName = ClientMapLoadAllTest.randomMapName();
        AtomicBoolean breakMe = new AtomicBoolean(false);
        Config config = this.createNewConfig(mapName, new BrokenLoadSimpleStore(breakMe));
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance(config);
        this.hazelcastFactory.newHazelcastInstance(config);
        this.hazelcastFactory.newHazelcastInstance(config);
        try {
            IMap map = server.getMap(mapName);
            ClientMapLoadAllTest.populateMap(map, 1000);
            map.clear();
        }
        catch (Exception e) {
            Assert.fail();
        }
        breakMe.set(true);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(this.getClientConfig());
        client.getMap(mapName);
    }

    @Test
    public void testLoadAll_givenKeys() throws Exception {
        String mapName = ClientMapLoadAllTest.randomMapName();
        Config config = this.createNewConfig(mapName);
        this.hazelcastFactory.newHazelcastInstance(config);
        this.hazelcastFactory.newHazelcastInstance(config);
        this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(this.getClientConfig());
        IMap map = client.getMap(mapName);
        ClientMapLoadAllTest.populateMap(map, 1000);
        map.evictAll();
        Set keysToLoad = ClientMapLoadAllTest.selectKeysToLoad(10, 910);
        map.loadAll(keysToLoad, true);
        Assert.assertEquals((long)900L, (long)map.size());
        ClientMapLoadAllTest.assertRangeLoaded(map, 10, 910);
    }

    @Test
    public void givenSpecificKeysWereReloaded_whenLoadAllIsCalled_thenAllEntriesAreLoadedFromTheStore() {
        String name = ClientMapLoadAllTest.randomString();
        int keysInMapStore = 10000;
        Config config = this.getConfig();
        MapConfig mapConfig = config.getMapConfig(name);
        MapStoreConfig mapStoreConfig = new MapStoreConfig();
        mapStoreConfig.setEnabled(true);
        mapStoreConfig.setImplementation((Object)new MapLoaderTest.DummyMapLoader(keysInMapStore));
        mapStoreConfig.setInitialLoadMode(MapStoreConfig.InitialLoadMode.EAGER);
        mapConfig.setMapStoreConfig(mapStoreConfig);
        this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(this.getClientConfig());
        IMap map = client.getMap(name);
        map.loadAll(TestCollectionUtils.setOfValuesBetween((int)0, (int)keysInMapStore), true);
        map.clear();
        map.loadAll(true);
        Assert.assertEquals((long)keysInMapStore, (long)map.size());
    }

    @Test
    public void testLoadAll_allKeys() throws Exception {
        String mapName = ClientMapLoadAllTest.randomMapName();
        Config config = this.createNewConfig(mapName);
        this.hazelcastFactory.newHazelcastInstance(config);
        this.hazelcastFactory.newHazelcastInstance(config);
        this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(this.getClientConfig());
        IMap map = client.getMap(mapName);
        ClientMapLoadAllTest.populateMap(map, 1000);
        map.evictAll();
        map.loadAll(true);
        Assert.assertEquals((long)1000L, (long)map.size());
    }

    protected ClientConfig getClientConfig() {
        return new ClientConfig();
    }

    private Config createNewConfig(String mapName) {
        return this.createNewConfig(mapName, new SimpleStore());
    }

    private Config createNewConfig(String mapName, MapStore mapStore) {
        return this.newConfig(mapName, mapStore, 0);
    }

    private static void populateMap(IMap map, int itemCount) {
        for (int i = 0; i < itemCount; ++i) {
            map.put((Object)i, (Object)i);
        }
    }

    private static Set selectKeysToLoad(int rangeStart, int rangeEnd) {
        HashSet<Integer> keysToLoad = new HashSet<Integer>();
        for (int i = rangeStart; i < rangeEnd; ++i) {
            keysToLoad.add(i);
        }
        return keysToLoad;
    }

    private static void assertRangeLoaded(IMap map, int rangeStart, int rangeEnd) {
        for (int i = rangeStart; i < rangeEnd; ++i) {
            Assert.assertEquals((Object)i, (Object)map.get((Object)i));
        }
    }

    private static class BrokenLoadSimpleStore
    extends SimpleStore {
        private final AtomicBoolean breakMe;

        private BrokenLoadSimpleStore(AtomicBoolean breakMe) {
            this.breakMe = breakMe;
        }

        @Override
        public Object load(Object key) {
            this.testClientRequest();
            return null;
        }

        @Override
        public Map loadAll(Collection keys) {
            this.testClientRequest();
            return null;
        }

        private boolean testClientRequest() {
            if (this.breakMe.get()) {
                throw new ClassCastException();
            }
            return false;
        }
    }

    private static class SimpleStore
    implements MapStore {
        private ConcurrentMap store = new ConcurrentHashMap();

        private SimpleStore() {
        }

        public void store(Object key, Object value) {
            this.store.put(key, value);
        }

        public void storeAll(Map map) {
            Set entrySet = map.entrySet();
            for (Map.Entry entry : entrySet) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                this.store(key, value);
            }
        }

        public void delete(Object key) {
        }

        public void deleteAll(Collection keys) {
        }

        public Object load(Object key) {
            return this.store.get(key);
        }

        public Map loadAll(Collection keys) {
            HashMap map = new HashMap();
            for (Object key : keys) {
                Object value = this.load(key);
                map.put(key, value);
            }
            return map;
        }

        public Set loadAllKeys() {
            return this.store.keySet();
        }
    }
}

