/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.projection.Projection;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapProjectSerializationTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @Before
    public void setup() {
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testProjectObjectShouldDeserializedOnlyTwice() {
        this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        IMap map = client.getMap("test");
        OnlyDeserializedTwiceObject value = new OnlyDeserializedTwiceObject("test");
        map.put((Object)1, (Object)value);
        Collection result = map.project((Projection)new ValuesProjection());
        Assert.assertEquals(Collections.singletonList(value), (Object)result);
    }

    private static class OnlyDeserializedTwiceObject
    implements DataSerializable {
        private String value;
        private static AtomicInteger readCalled = new AtomicInteger(0);

        public OnlyDeserializedTwiceObject() {
        }

        public OnlyDeserializedTwiceObject(String value) {
            this.value = value;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeUTF(this.value);
        }

        public void readData(ObjectDataInput in) throws IOException {
            if (readCalled.incrementAndGet() > 2) {
                throw new AssertionError((Object)"Read called more than twice!!!");
            }
            this.value = in.readUTF();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof OnlyDeserializedTwiceObject)) {
                return false;
            }
            OnlyDeserializedTwiceObject that = (OnlyDeserializedTwiceObject)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return this.value.hashCode();
        }
    }

    public static class ValuesProjection
    extends Projection<Map.Entry<Integer, OnlyDeserializedTwiceObject>, OnlyDeserializedTwiceObject>
    implements Serializable {
        public OnlyDeserializedTwiceObject transform(Map.Entry<Integer, OnlyDeserializedTwiceObject> input) {
            return input.getValue();
        }
    }
}

