/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.MapStoreConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.core.MapStore;
import com.hazelcast.map.impl.mapstore.writebehind.MapStoreWithCounter;
import com.hazelcast.map.impl.mapstore.writebehind.TemporaryBlockerMapStore;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindOnBackupsTest;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientWriteBehindFlushTest
extends HazelcastTestSupport {
    private static final String MAP_NAME = "default";
    private TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void tearDown() throws Exception {
        this.hazelcastFactory.shutdownAll();
    }

    @Test
    public void testWriteBehindQueues_emptied_onOwnerAndBackupNodes() {
        MapStoreWithCounter mapStore = new MapStoreWithCounter();
        MapStoreConfig mapStoreConfig = new MapStoreConfig().setImplementation((Object)mapStore).setWriteDelaySeconds(3000);
        Config config = this.getConfig();
        config.getMapConfig(MAP_NAME).setMapStoreConfig(mapStoreConfig);
        HazelcastInstance member1 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance member2 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance member3 = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(this.getClientConfig());
        IMap map = client.getMap(MAP_NAME);
        for (int i = 0; i < 1000; ++i) {
            map.put((Object)i, (Object)i);
        }
        map.flush();
        this.assertWriteBehindQueuesEmpty(MAP_NAME, Arrays.asList(member1, member2, member3));
    }

    @Test
    public void testFlush_shouldNotCause_concurrentStoreOperation() {
        int blockStoreOperationSeconds = 5;
        TemporaryBlockerMapStore store = new TemporaryBlockerMapStore(blockStoreOperationSeconds);
        Config config = this.newMapStoredConfig((MapStore)store, 2);
        this.hazelcastFactory.newHazelcastInstance(config);
        IMap map = this.hazelcastFactory.newHazelcastClient(this.getClientConfig()).getMap(MAP_NAME);
        map.put((Object)"key", (Object)"value");
        map.flush();
        Assert.assertEquals((String)"Expecting only one store after flush", (long)1L, (long)store.getStoreOperationCount());
    }

    protected ClientConfig getClientConfig() {
        return new ClientConfig();
    }

    protected Config newMapStoredConfig(MapStore store, int writeDelaySeconds) {
        MapStoreConfig mapStoreConfig = new MapStoreConfig().setEnabled(true).setWriteDelaySeconds(writeDelaySeconds).setImplementation((Object)store);
        Config config = this.getConfig();
        config.getMapConfig(MAP_NAME).setMapStoreConfig(mapStoreConfig);
        return config;
    }

    protected void assertWriteBehindQueuesEmpty(final String mapName, final List<HazelcastInstance> nodes) {
        ClientWriteBehindFlushTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                for (HazelcastInstance instance : nodes) {
                    Assert.assertEquals((long)0L, (long)WriteBehindOnBackupsTest.writeBehindQueueSize((HazelcastInstance)instance, (String)mapName));
                }
            }
        });
    }
}

