/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.helpers.PortableHelpersFactory;
import com.hazelcast.client.helpers.SimpleClientInterceptor;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class SimpleClientMapInterceptorTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;
    private SimpleClientInterceptor interceptor;

    @Before
    public void setup() {
        Config config = this.getConfig();
        config.getSerializationConfig().addPortableFactory(666, (PortableFactory)new PortableHelpersFactory());
        this.hazelcastFactory.newHazelcastInstance(config);
        this.hazelcastFactory.newHazelcastInstance(config);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getSerializationConfig().addPortableFactory(666, (PortableFactory)new PortableHelpersFactory());
        this.client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        this.interceptor = new SimpleClientInterceptor();
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void clientMapInterceptorTestIssue1238() throws InterruptedException {
        IMap map = this.client.getMap("clientMapInterceptorTest");
        String id = map.addInterceptor((MapInterceptor)this.interceptor);
        map.put((Object)1, (Object)"New York");
        map.put((Object)2, (Object)"Istanbul");
        map.put((Object)3, (Object)"Tokyo");
        map.put((Object)4, (Object)"London");
        map.put((Object)5, (Object)"Paris");
        map.put((Object)6, (Object)"Cairo");
        map.put((Object)7, (Object)"Hong Kong");
        map.remove((Object)1);
        try {
            map.remove((Object)2);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((long)map.size(), (long)6L);
        Assert.assertEquals((Object)map.get((Object)1), null);
        Assert.assertEquals((Object)map.get((Object)2), (Object)"ISTANBUL:");
        Assert.assertEquals((Object)map.get((Object)3), (Object)"TOKYO:");
        Assert.assertEquals((Object)map.get((Object)4), (Object)"LONDON:");
        Assert.assertEquals((Object)map.get((Object)5), (Object)"PARIS:");
        Assert.assertEquals((Object)map.get((Object)6), (Object)"CAIRO:");
        Assert.assertEquals((Object)map.get((Object)7), (Object)"HONG KONG:");
        map.removeInterceptor(id);
        map.put((Object)8, (Object)"Moscow");
        Assert.assertEquals((Object)map.get((Object)8), (Object)"Moscow");
        Assert.assertEquals((Object)map.get((Object)1), null);
        Assert.assertEquals((Object)map.get((Object)2), (Object)"ISTANBUL");
        Assert.assertEquals((Object)map.get((Object)3), (Object)"TOKYO");
        Assert.assertEquals((Object)map.get((Object)4), (Object)"LONDON");
        Assert.assertEquals((Object)map.get((Object)5), (Object)"PARIS");
        Assert.assertEquals((Object)map.get((Object)6), (Object)"CAIRO");
        Assert.assertEquals((Object)map.get((Object)7), (Object)"HONG KONG");
    }
}

