/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MapAddNearCacheInvalidationListenerCodec;
import com.hazelcast.client.proxy.NearCachedClientMapProxy;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.core.IMap;
import com.hazelcast.internal.nearcache.NearCacheInvalidationListener;
import com.hazelcast.nio.serialization.Data;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;

class ClientMapInvalidationListener
extends MapAddNearCacheInvalidationListenerCodec.AbstractEventHandler
implements NearCacheInvalidationListener,
EventHandler<ClientMessage> {
    private final AtomicLong invalidationCount = new AtomicLong();

    ClientMapInvalidationListener() {
    }

    public long getInvalidationCount() {
        return this.invalidationCount.get();
    }

    public void resetInvalidationCount() {
        this.invalidationCount.set(0L);
    }

    public void handle(Data key, String sourceUuid, UUID partitionUuid, long sequence) {
        this.invalidationCount.incrementAndGet();
    }

    public void handle(Collection<Data> keys, Collection<String> sourceUuids, Collection<UUID> partitionUuids, Collection<Long> sequences) {
        this.invalidationCount.addAndGet(keys.size());
    }

    public void beforeListenerRegister() {
    }

    public void onListenerRegister() {
    }

    static NearCacheInvalidationListener createInvalidationEventHandler(IMap clientMap) {
        ClientMapInvalidationListener invalidationListener = new ClientMapInvalidationListener();
        ((NearCachedClientMapProxy)clientMap).addNearCacheInvalidationListener((EventHandler)invalidationListener);
        return invalidationListener;
    }
}

