/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.map.impl.nearcache.invalidation;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.internal.nearcache.impl.invalidation.Invalidator;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataGenerator;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.nearcache.MapNearCacheManager;
import com.hazelcast.map.impl.nearcache.NearCacheTestSupport;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.util.RandomPicker;
import com.hazelcast.util.UuidUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={NightlyTest.class})
public class InvalidationMetadataDistortionTest
extends NearCacheTestSupport {
    private final TestHazelcastFactory factory = new TestHazelcastFactory();

    @After
    public void tearDown() throws Exception {
        this.factory.shutdownAll();
    }

    protected Config createConfig() {
        Config config = this.getConfig();
        config.setProperty(GroupProperty.PARTITION_COUNT.getName(), "271");
        config.setProperty(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_ENABLED.getName(), "true");
        config.setProperty(GroupProperty.CACHE_INVALIDATION_MESSAGE_BATCH_SIZE.getName(), "10");
        return config;
    }

    protected MapConfig createMapConfig(String mapName) {
        MapConfig mapConfig = new MapConfig(mapName);
        mapConfig.setBackupCount(0);
        return mapConfig;
    }

    protected NearCacheConfig createNearCacheConfig(String mapName) {
        NearCacheConfig nearCacheConfig = this.newNearCacheConfig();
        nearCacheConfig.setInvalidateOnChange(true);
        nearCacheConfig.setName(mapName);
        nearCacheConfig.getEvictionConfig().setSize(Integer.MAX_VALUE).setEvictionPolicy(EvictionPolicy.NONE);
        return nearCacheConfig;
    }

    protected ClientConfig createClientConfig() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty("hazelcast.invalidation.max.tolerated.miss.count", "0");
        return clientConfig;
    }

    @Test
    public void lostInvalidation() throws Exception {
        String mapName = "origin-map";
        int mapSize = 100000;
        final AtomicBoolean stopTest = new AtomicBoolean();
        Config config = this.createConfig().addMapConfig(this.createMapConfig("origin-map"));
        final HazelcastInstance member = this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastInstance(config);
        final IMap memberMap = member.getMap("origin-map");
        for (int i = 0; i < 100000; ++i) {
            memberMap.put((Object)i, (Object)i);
        }
        ClientConfig clientConfig = this.createClientConfig().addNearCacheConfig(this.createNearCacheConfig("origin-map"));
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        final IMap clientMap = client.getMap("origin-map");
        Thread populateNearCache = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stopTest.get()) {
                    for (int i = 0; i < 100000; ++i) {
                        clientMap.get((Object)i);
                    }
                }
            }
        });
        Thread distortSequence = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stopTest.get()) {
                    InvalidationMetadataDistortionTest.this.distortRandomPartitionSequence("origin-map", member);
                    HazelcastTestSupport.sleepSeconds((int)1);
                }
            }
        });
        Thread distortUuid = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stopTest.get()) {
                    InvalidationMetadataDistortionTest.this.distortRandomPartitionUuid(member);
                    HazelcastTestSupport.sleepSeconds((int)5);
                }
            }
        });
        Thread put = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!stopTest.get()) {
                    int key = RandomPicker.getInt((int)100000);
                    int value = RandomPicker.getInt((int)Integer.MAX_VALUE);
                    memberMap.put((Object)key, (Object)value);
                    HazelcastTestSupport.sleepAtLeastMillis((long)100L);
                }
            }
        });
        put.start();
        populateNearCache.start();
        distortSequence.start();
        distortUuid.start();
        InvalidationMetadataDistortionTest.sleepSeconds((int)60);
        stopTest.set(true);
        distortUuid.join();
        distortSequence.join();
        populateNearCache.join();
        put.join();
        InvalidationMetadataDistortionTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                for (int i = 0; i < 100000; ++i) {
                    Integer valueSeenFromMember = (Integer)memberMap.get((Object)i);
                    Integer valueSeenFromClient = (Integer)clientMap.get((Object)i);
                    Assert.assertEquals((Object)valueSeenFromMember, (Object)valueSeenFromClient);
                }
            }
        });
    }

    private void distortRandomPartitionSequence(String mapName, HazelcastInstance member) {
        NodeEngineImpl nodeEngineImpl = InvalidationMetadataDistortionTest.getNodeEngineImpl((HazelcastInstance)member);
        MapService mapService = (MapService)nodeEngineImpl.getService("hz:impl:mapService");
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        MapNearCacheManager mapNearCacheManager = mapServiceContext.getMapNearCacheManager();
        Invalidator invalidator = mapNearCacheManager.getInvalidator();
        MetaDataGenerator metaDataGenerator = invalidator.getMetaDataGenerator();
        InternalPartitionService partitionService = nodeEngineImpl.getPartitionService();
        int partitionCount = partitionService.getPartitionCount();
        metaDataGenerator.setCurrentSequence(mapName, RandomPicker.getInt((int)partitionCount), (long)RandomPicker.getInt((int)Integer.MAX_VALUE));
    }

    private void distortRandomPartitionUuid(HazelcastInstance member) {
        NodeEngineImpl nodeEngineImpl = InvalidationMetadataDistortionTest.getNodeEngineImpl((HazelcastInstance)member);
        int partitionCount = nodeEngineImpl.getPartitionService().getPartitionCount();
        int partitionId = RandomPicker.getInt((int)partitionCount);
        MapService mapService = (MapService)nodeEngineImpl.getService("hz:impl:mapService");
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        MapNearCacheManager mapNearCacheManager = mapServiceContext.getMapNearCacheManager();
        Invalidator invalidator = mapNearCacheManager.getInvalidator();
        MetaDataGenerator metaDataGenerator = invalidator.getMetaDataGenerator();
        metaDataGenerator.setUuid(partitionId, UuidUtil.newUnsecureUUID());
    }

    protected HazelcastClientInstanceImpl getHazelcastClientInstanceImpl(HazelcastInstance client) {
        HazelcastClientProxy clientProxy = (HazelcastClientProxy)client;
        return clientProxy.client;
    }
}

