/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.mapreduce;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
@Ignore
public class MapReduceLiteMemberTest {
    private TestHazelcastFactory factory;
    private HazelcastInstance client;
    private HazelcastInstance lite;
    private HazelcastInstance lite2;
    private HazelcastInstance instance;
    private HazelcastInstance instance2;

    @Before
    public void before() {
        this.factory = new TestHazelcastFactory();
        this.lite = this.factory.newHazelcastInstance(new Config().setLiteMember(true));
        this.lite2 = this.factory.newHazelcastInstance(new Config().setLiteMember(true));
        this.instance = this.factory.newHazelcastInstance();
        this.instance2 = this.factory.newHazelcastInstance();
        HazelcastTestSupport.assertClusterSize((int)4, (HazelcastInstance[])new HazelcastInstance[]{this.lite, this.instance2});
        HazelcastTestSupport.assertClusterSizeEventually((int)4, (HazelcastInstance[])new HazelcastInstance[]{this.lite2, this.instance});
        this.client = this.factory.newHazelcastClient();
    }

    @After
    public void after() {
        this.factory.terminateAll();
    }

    @Test(timeout=60000L)
    public void testMapper() throws Exception {
        com.hazelcast.mapreduce.MapReduceLiteMemberTest.testMapper((HazelcastInstance)this.client);
    }

    @Test(timeout=60000L)
    public void testKeyedMapperCollator() throws Exception {
        com.hazelcast.mapreduce.MapReduceLiteMemberTest.testKeyedMapperCollator((HazelcastInstance)this.client);
    }

    @Test(timeout=60000L)
    public void testMapperComplexMapping() throws Exception {
        com.hazelcast.mapreduce.MapReduceLiteMemberTest.testMapperComplexMapping((HazelcastInstance)this.client);
    }

    @Test(timeout=60000L)
    public void testMapperCollator() throws Exception {
        com.hazelcast.mapreduce.MapReduceLiteMemberTest.testMapperCollator((HazelcastInstance)this.client);
    }

    @Test(timeout=60000L)
    public void testMapperReducerCollator() throws Exception {
        com.hazelcast.mapreduce.MapReduceLiteMemberTest.testMapperReducerCollator((HazelcastInstance)this.client);
    }

    @Test(timeout=120000L)
    public void testMapReduceJobSubmissionWithNoDataNode() throws Exception {
        this.instance.getLifecycleService().terminate();
        this.instance2.getLifecycleService().terminate();
        HazelcastTestSupport.assertClusterSizeEventually((int)2, (HazelcastInstance[])new HazelcastInstance[]{this.lite, this.lite2});
        ICompletableFuture future = com.hazelcast.mapreduce.MapReduceLiteMemberTest.testMapReduceJobSubmissionWithNoDataNode((HazelcastInstance)this.client);
        try {
            future.get(120L, TimeUnit.SECONDS);
            Assert.fail((String)"Map-reduce job should not be submitted when there is no data member");
        }
        catch (ExecutionException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof IllegalStateException));
        }
    }
}

