/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.mapreduce.aggregation;

import com.hazelcast.client.mapreduce.aggregation.AbstractAggregationTest;
import com.hazelcast.core.IMap;
import com.hazelcast.mapreduce.aggregation.Aggregation;
import com.hazelcast.mapreduce.aggregation.Aggregations;
import com.hazelcast.mapreduce.aggregation.Supplier;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Random;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
@Ignore
public class AvgAggregationTest
extends AbstractAggregationTest {
    @Test(timeout=60000L)
    public void testBigDecimalAvg() throws Exception {
        BigDecimal[] values = AvgAggregationTest.buildPlainValues(new AbstractAggregationTest.ValueProvider<BigDecimal>(){

            @Override
            public BigDecimal provideRandom(Random random) {
                return BigDecimal.valueOf(10000.0 + (double)AbstractAggregationTest.random(1000, 2000));
            }
        }, BigDecimal.class);
        BigDecimal expectation = BigDecimal.ZERO;
        for (int i = 0; i < values.length; ++i) {
            expectation = expectation.add(values[i]);
        }
        expectation = expectation.divide(BigDecimal.valueOf(values.length));
        Aggregation aggregation = Aggregations.bigDecimalAvg();
        BigDecimal result = (BigDecimal)this.testAvg(values, aggregation);
        Assert.assertEquals((Object)expectation, (Object)result);
    }

    @Test(timeout=60000L)
    public void testBigIntegerAvg() throws Exception {
        BigInteger[] values = AvgAggregationTest.buildPlainValues(new AbstractAggregationTest.ValueProvider<BigInteger>(){

            @Override
            public BigInteger provideRandom(Random random) {
                return BigInteger.valueOf(10000L + (long)AbstractAggregationTest.random(1000, 2000));
            }
        }, BigInteger.class);
        BigInteger expectation = BigInteger.ZERO;
        for (int i = 0; i < values.length; ++i) {
            expectation = expectation.add(values[i]);
        }
        expectation = expectation.divide(BigInteger.valueOf(values.length));
        Aggregation aggregation = Aggregations.bigIntegerAvg();
        BigInteger result = (BigInteger)this.testAvg(values, aggregation);
        Assert.assertEquals((Object)expectation, (Object)result);
    }

    @Test(timeout=60000L)
    public void testDoubleAvg() throws Exception {
        Double[] values = AvgAggregationTest.buildPlainValues(new AbstractAggregationTest.ValueProvider<Double>(){

            @Override
            public Double provideRandom(Random random) {
                return 10000.0 + (double)AbstractAggregationTest.random(1000, 2000);
            }
        }, Double.class);
        double expectation = 0.0;
        for (int i = 0; i < values.length; ++i) {
            expectation += values[i].doubleValue();
        }
        Aggregation aggregation = Aggregations.doubleAvg();
        double result = (Double)this.testAvg(values, aggregation);
        Assert.assertEquals((double)(expectation /= (double)values.length), (double)result, (double)0.0);
    }

    @Test(timeout=60000L)
    public void testIntegerAvg() throws Exception {
        Integer[] values = AvgAggregationTest.buildPlainValues(new AbstractAggregationTest.ValueProvider<Integer>(){

            @Override
            public Integer provideRandom(Random random) {
                return AbstractAggregationTest.random(1000, 2000);
            }
        }, Integer.class);
        int expectation = 0;
        for (int i = 0; i < values.length; ++i) {
            expectation += values[i].intValue();
        }
        expectation = (int)((double)expectation / (double)values.length);
        Aggregation aggregation = Aggregations.integerAvg();
        int result = (Integer)this.testAvg(values, aggregation);
        Assert.assertEquals((long)expectation, (long)result);
    }

    @Test(timeout=60000L)
    public void testLongAvg() throws Exception {
        Long[] values = AvgAggregationTest.buildPlainValues(new AbstractAggregationTest.ValueProvider<Long>(){

            @Override
            public Long provideRandom(Random random) {
                return 10000L + (long)AbstractAggregationTest.random(1000, 2000);
            }
        }, Long.class);
        long expectation = 0L;
        for (int i = 0; i < values.length; ++i) {
            expectation += values[i].longValue();
        }
        expectation = (long)((double)expectation / (double)values.length);
        Aggregation aggregation = Aggregations.longAvg();
        long result = (Long)this.testAvg(values, aggregation);
        Assert.assertEquals((long)expectation, (long)result);
    }

    @Test(timeout=60000L)
    public void testBigDecimalAvgWithExtractor() throws Exception {
        AbstractAggregationTest.Value<BigDecimal>[] values = AvgAggregationTest.buildValues(new AbstractAggregationTest.ValueProvider<BigDecimal>(){

            @Override
            public BigDecimal provideRandom(Random random) {
                return BigDecimal.valueOf(10000.0 + (double)AbstractAggregationTest.random(1000, 2000));
            }
        });
        BigDecimal expectation = BigDecimal.ZERO;
        for (int i = 0; i < values.length; ++i) {
            expectation = expectation.add((BigDecimal)values[i].value);
        }
        expectation = expectation.divide(BigDecimal.valueOf(values.length));
        Aggregation aggregation = Aggregations.bigDecimalAvg();
        BigDecimal result = (BigDecimal)this.testAvgWithExtractor(values, aggregation);
        Assert.assertEquals((Object)expectation, (Object)result);
    }

    @Test(timeout=60000L)
    public void testBigIntegerAvgWithExtractor() throws Exception {
        AbstractAggregationTest.Value<BigInteger>[] values = AvgAggregationTest.buildValues(new AbstractAggregationTest.ValueProvider<BigInteger>(){

            @Override
            public BigInteger provideRandom(Random random) {
                return BigInteger.valueOf(10000L + (long)AbstractAggregationTest.random(1000, 2000));
            }
        });
        BigInteger expectation = BigInteger.ZERO;
        for (int i = 0; i < values.length; ++i) {
            expectation = expectation.add((BigInteger)values[i].value);
        }
        expectation = expectation.divide(BigInteger.valueOf(values.length));
        Aggregation aggregation = Aggregations.bigIntegerAvg();
        BigInteger result = (BigInteger)this.testAvgWithExtractor(values, aggregation);
        Assert.assertEquals((Object)expectation, (Object)result);
    }

    @Test(timeout=60000L)
    public void testDoubleAvgWithExtractor() throws Exception {
        AbstractAggregationTest.Value<Double>[] values = AvgAggregationTest.buildValues(new AbstractAggregationTest.ValueProvider<Double>(){

            @Override
            public Double provideRandom(Random random) {
                return 10000.0 + (double)AbstractAggregationTest.random(1000, 2000);
            }
        });
        double expectation = 0.0;
        for (int i = 0; i < values.length; ++i) {
            expectation += ((Double)values[i].value).doubleValue();
        }
        Aggregation aggregation = Aggregations.doubleAvg();
        double result = (Double)this.testAvgWithExtractor(values, aggregation);
        Assert.assertEquals((double)(expectation /= (double)values.length), (double)result, (double)0.0);
    }

    @Test(timeout=60000L)
    public void testIntegerAvgWithExtractor() throws Exception {
        AbstractAggregationTest.Value<Integer>[] values = AvgAggregationTest.buildValues(new AbstractAggregationTest.ValueProvider<Integer>(){

            @Override
            public Integer provideRandom(Random random) {
                return AbstractAggregationTest.random(1000, 2000);
            }
        });
        int expectation = 0;
        for (int i = 0; i < values.length; ++i) {
            expectation += ((Integer)values[i].value).intValue();
        }
        expectation = (int)((double)expectation / (double)values.length);
        Aggregation aggregation = Aggregations.integerAvg();
        int result = (Integer)this.testAvgWithExtractor(values, aggregation);
        Assert.assertEquals((long)expectation, (long)result);
    }

    @Test(timeout=60000L)
    public void testLongAvgWithExtractor() throws Exception {
        AbstractAggregationTest.Value<Long>[] values = AvgAggregationTest.buildValues(new AbstractAggregationTest.ValueProvider<Long>(){

            @Override
            public Long provideRandom(Random random) {
                return 10000L + (long)AbstractAggregationTest.random(1000, 2000);
            }
        });
        long expectation = 0L;
        for (int i = 0; i < values.length; ++i) {
            expectation += ((Long)values[i].value).longValue();
        }
        expectation = (long)((double)expectation / (double)values.length);
        Aggregation aggregation = Aggregations.longAvg();
        long result = (Long)this.testAvgWithExtractor(values, aggregation);
        Assert.assertEquals((long)expectation, (long)result);
    }

    private <T, R> R testAvg(T[] values, Aggregation<String, T, R> aggregation) throws Exception {
        String mapName = AvgAggregationTest.randomMapName();
        IMap map = this.client.getMap(mapName);
        for (int i = 0; i < values.length; ++i) {
            map.put((Object)("key-" + i), values[i]);
        }
        Supplier supplier = Supplier.all();
        return (R)map.aggregate(supplier, aggregation);
    }

    private <T, R> R testAvgWithExtractor(AbstractAggregationTest.Value<T>[] values, Aggregation<String, T, R> aggregation) throws Exception {
        String mapName = AvgAggregationTest.randomMapName();
        IMap map = this.client.getMap(mapName);
        for (int i = 0; i < values.length; ++i) {
            map.put((Object)("key-" + i), values[i]);
        }
        Supplier supplier = Supplier.all(new AbstractAggregationTest.ValuePropertyExtractor());
        return (R)map.aggregate(supplier, aggregation);
    }
}

