/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.multimap;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.MultiMap;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMultiMapListenersTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance server;
    private HazelcastInstance client;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        this.server = this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddLocalEntryListener_whenNull() {
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        mm.addLocalEntryListener(null);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testAddLocalEntryListener() {
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        CountDownValueNotNullListener myEntryListener = new CountDownValueNotNullListener(1);
        mm.addLocalEntryListener((EntryListener)myEntryListener);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddListener_whenListenerNull() throws InterruptedException {
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        mm.addEntryListener(null, true);
    }

    @Test
    public void testRemoveListener() throws InterruptedException {
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        CountDownValueNotNullListener listener = new CountDownValueNotNullListener(1);
        String id = mm.addEntryListener((EntryListener)listener, true);
        Assert.assertTrue((boolean)mm.removeEntryListener(id));
    }

    @Test
    public void testRemoveListener_whenNotExist() throws InterruptedException {
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        Assert.assertFalse((boolean)mm.removeEntryListener("NOT_THERE"));
    }

    @Test
    public void testListenerEntryAddEvent() throws InterruptedException {
        int maxKeys = 12;
        int maxItems = 3;
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        CountDownValueNotNullListener listener = new CountDownValueNotNullListener(36);
        mm.addEntryListener((EntryListener)listener, true);
        for (int i = 0; i < 12; ++i) {
            for (int j = 0; j < 12; ++j) {
                mm.put((Object)i, (Object)j);
            }
        }
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)listener.addLatch);
    }

    @Test
    public void testListenerEntryAddEvent_whenValueNotIncluded() throws InterruptedException {
        int maxKeys = 21;
        int maxItems = 3;
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        CountDownValueNullListener listener = new CountDownValueNullListener(63);
        mm.addEntryListener((EntryListener)listener, false);
        for (int i = 0; i < 21; ++i) {
            for (int j = 0; j < 21; ++j) {
                mm.put((Object)i, (Object)j);
            }
        }
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)listener.addLatch);
    }

    @Test
    public void testListenerEntryRemoveEvent() throws InterruptedException {
        int maxKeys = 25;
        int maxItems = 3;
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        CountDownValueNotNullListener listener = new CountDownValueNotNullListener(75);
        mm.addEntryListener((EntryListener)listener, true);
        for (int i = 0; i < 25; ++i) {
            for (int j = 0; j < 25; ++j) {
                mm.put((Object)i, (Object)j);
                mm.remove((Object)i);
            }
        }
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)listener.removeLatch);
    }

    @Test
    public void testListenerEntryRemoveEvent_whenValueNotIncluded() throws InterruptedException {
        int maxKeys = 31;
        int maxItems = 3;
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        CountDownValueNullListener listener = new CountDownValueNullListener(93);
        mm.addEntryListener((EntryListener)listener, false);
        for (int i = 0; i < 31; ++i) {
            for (int j = 0; j < 31; ++j) {
                mm.put((Object)i, (Object)j);
                mm.remove((Object)i);
            }
        }
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)listener.removeLatch);
    }

    @Test
    public void testListenerOnKeyEntryAddEvent() throws InterruptedException {
        String key = "key";
        int maxItems = 42;
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        CountDownValueNotNullListener listener = new CountDownValueNotNullListener(42);
        mm.addEntryListener((EntryListener)listener, (Object)key, true);
        for (int i = 0; i < 42; ++i) {
            mm.put((Object)key, (Object)i);
        }
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)listener.addLatch);
    }

    @Test
    public void testListenerOnKey_whenOtherKeysAdded() throws InterruptedException {
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        final ArrayList events = new ArrayList();
        mm.addEntryListener((EntryListener)new EntryAdapter(){

            public void entryAdded(EntryEvent event) {
                events.add(event);
            }
        }, (Object)"key", true);
        mm.put((Object)"key2", (Object)"value");
        mm.put((Object)"key", (Object)"value");
        HazelcastTestSupport.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)1L, (long)events.size());
                Assert.assertEquals((Object)"key", (Object)((EntryEvent)events.get(0)).getKey());
            }
        });
    }

    @Test
    public void testListenerOnKeyEntryAddEvent_whenValueNotIncluded() throws InterruptedException {
        String key = "key";
        int maxItems = 72;
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        CountDownValueNullListener listener = new CountDownValueNullListener(72);
        mm.addEntryListener((EntryListener)listener, (Object)key, false);
        for (int i = 0; i < 72; ++i) {
            mm.put((Object)key, (Object)i);
        }
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)listener.addLatch);
    }

    @Test
    public void testListenerOnKeyEntryRemoveEvent() throws InterruptedException {
        String key = "key";
        int maxItems = 88;
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        CountDownValueNotNullListener listener = new CountDownValueNotNullListener(88);
        mm.addEntryListener((EntryListener)listener, (Object)key, true);
        for (int i = 0; i < 88; ++i) {
            mm.put((Object)key, (Object)i);
            mm.remove((Object)key, (Object)i);
        }
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)listener.removeLatch);
    }

    @Test
    public void testListenerOnKeyEntryRemoveEvent_whenValueNotIncluded() throws InterruptedException {
        String key = "key";
        int maxItems = 62;
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        CountDownValueNullListener listener = new CountDownValueNullListener(62);
        mm.addEntryListener((EntryListener)listener, (Object)key, false);
        for (int i = 0; i < 62; ++i) {
            mm.put((Object)key, (Object)i);
            mm.remove((Object)key, (Object)i);
        }
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)listener.removeLatch);
    }

    @Test
    public void testListenerOnKeyEntryRemove_WithOneRemove() throws InterruptedException {
        String key = "key";
        int maxItems = 98;
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        CountDownValueNotNullListener listener = new CountDownValueNotNullListener(98, 1);
        String id = mm.addEntryListener((EntryListener)listener, (Object)key, true);
        for (int i = 0; i < 98; ++i) {
            mm.put((Object)key, (Object)i);
        }
        mm.remove((Object)key);
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)listener.removeLatch);
    }

    @Test
    public void testListenerOnKeyEntryRemove_WithOneRemoveWhenValueNotIncluded() throws InterruptedException {
        String key = "key";
        int maxItems = 56;
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        CountDownValueNullListener listener = new CountDownValueNullListener(56, 1);
        String id = mm.addEntryListener((EntryListener)listener, (Object)key, false);
        for (int i = 0; i < 56; ++i) {
            mm.put((Object)key, (Object)i);
        }
        mm.remove((Object)key);
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)listener.removeLatch);
    }

    @Test
    public void testListeners_clearAll() {
        MultiMap mm = this.client.getMultiMap(HazelcastTestSupport.randomString());
        CountDownValueNullListener listener = new CountDownValueNullListener(1);
        mm.addEntryListener((EntryListener)listener, false);
        mm.put((Object)"key", (Object)"value");
        mm.clear();
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)listener.addLatch);
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)listener.clearLatch);
    }

    @Test
    public void testListeners_clearAllFromNode() {
        String name = HazelcastTestSupport.randomString();
        MultiMap mm = this.client.getMultiMap(name);
        CountDownValueNullListener listener = new CountDownValueNullListener(1);
        mm.addEntryListener((EntryListener)listener, false);
        mm.put((Object)"key", (Object)"value");
        this.server.getMultiMap(name).clear();
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)listener.addLatch);
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)listener.clearLatch);
    }

    static class CountDownValueNullListener
    extends MyEntryListener {
        public CountDownValueNullListener(int latchCount) {
            super(latchCount);
        }

        public CountDownValueNullListener(int addlatchCount, int removeLatchCount) {
            super(addlatchCount, removeLatchCount);
        }

        public void entryAdded(EntryEvent event) {
            if (event.getValue() == null) {
                this.addLatch.countDown();
            }
        }

        public void entryRemoved(EntryEvent event) {
            if (event.getOldValue() == null) {
                this.removeLatch.countDown();
            }
        }

        public void entryUpdated(EntryEvent event) {
            if (event.getValue() == null) {
                this.updateLatch.countDown();
            }
        }

        public void entryEvicted(EntryEvent event) {
            if (event.getValue() == null) {
                this.evictLatch.countDown();
            }
        }

        public void mapEvicted(MapEvent event) {
        }

        public void mapCleared(MapEvent event) {
            this.clearLatch.countDown();
        }
    }

    static class CountDownValueNotNullListener
    extends MyEntryListener {
        public CountDownValueNotNullListener(int latchCount) {
            super(latchCount);
        }

        public CountDownValueNotNullListener(int addlatchCount, int removeLatchCount) {
            super(addlatchCount, removeLatchCount);
        }

        public void entryAdded(EntryEvent event) {
            if (event.getValue() != null) {
                this.addLatch.countDown();
            }
        }

        public void entryRemoved(EntryEvent event) {
            if (event.getOldValue() != null) {
                this.removeLatch.countDown();
            }
        }

        public void entryUpdated(EntryEvent event) {
            if (event.getValue() != null) {
                this.updateLatch.countDown();
            }
        }

        public void entryEvicted(EntryEvent event) {
            if (event.getValue() != null) {
                this.evictLatch.countDown();
            }
        }

        public void mapEvicted(MapEvent event) {
        }

        public void mapCleared(MapEvent event) {
            this.clearLatch.countDown();
        }
    }

    static abstract class MyEntryListener
    extends EntryAdapter {
        public final CountDownLatch addLatch;
        public final CountDownLatch removeLatch;
        public final CountDownLatch updateLatch;
        public final CountDownLatch evictLatch;
        public final CountDownLatch clearLatch;

        public MyEntryListener(int latchCount) {
            this.addLatch = new CountDownLatch(latchCount);
            this.removeLatch = new CountDownLatch(latchCount);
            this.updateLatch = new CountDownLatch(1);
            this.evictLatch = new CountDownLatch(1);
            this.clearLatch = new CountDownLatch(1);
        }

        public MyEntryListener(int addlatchCount, int removeLatchCount) {
            this.addLatch = new CountDownLatch(addlatchCount);
            this.removeLatch = new CountDownLatch(removeLatchCount);
            this.updateLatch = new CountDownLatch(1);
            this.evictLatch = new CountDownLatch(1);
            this.clearLatch = new CountDownLatch(1);
        }
    }
}

