/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.queue;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IQueue;
import com.hazelcast.test.HazelcastTestSupport;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;

public class ClientQueuePerformanceBenchmark
extends HazelcastTestSupport {
    private static final AtomicLong TOTAL_OFFER = new AtomicLong();
    private static final AtomicLong TOTAL_POLL = new AtomicLong();
    private static final AtomicLong TOTAL_PEEK = new AtomicLong();
    private static final int THREAD_COUNT = 40;
    private static final byte[] VALUE = new byte[1000];
    private static HazelcastInstance server;
    private static IQueue<Object> queue;

    public static void main(String[] args) {
        System.setProperty("hazelcast.local.localAddress", "127.0.0.1");
        server = Hazelcast.newHazelcastInstance();
        Hazelcast.newHazelcastInstance();
        HazelcastInstance client = HazelcastClient.newHazelcastClient(null);
        queue = client.getQueue("test");
        ClientQueuePerformanceBenchmark.test2();
    }

    private static void test1() {
        final Random rnd = new Random();
        for (int i = 0; i < 40; ++i) {
            new Thread(){

                @Override
                public void run() {
                    while (true) {
                        int random;
                        if ((random = rnd.nextInt(100)) > 54) {
                            queue.poll();
                            TOTAL_POLL.incrementAndGet();
                            continue;
                        }
                        if (random > 4) {
                            queue.offer((Object)VALUE);
                            TOTAL_OFFER.incrementAndGet();
                            continue;
                        }
                        queue.peek();
                        TOTAL_PEEK.incrementAndGet();
                    }
                }
            }.start();
        }
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            int size;
                            if ((size = queue.size()) > 50000) {
                                System.err.println("cleaning a little");
                                for (int i = 0; i < 20000; ++i) {
                                    queue.poll();
                                    TOTAL_POLL.incrementAndGet();
                                }
                                Thread.sleep(2000L);
                                continue;
                            }
                            Thread.sleep(10000L);
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }.start();
        while (true) {
            int sleepTime = 10;
            ClientQueuePerformanceBenchmark.sleepSeconds((int)sleepTime);
            long totalOfferVal = TOTAL_OFFER.getAndSet(0L);
            long totalPollVal = TOTAL_POLL.getAndSet(0L);
            long totalPeekVal = TOTAL_PEEK.getAndSet(0L);
            System.err.println("_______________________________________________________________________________________");
            System.err.println(" offer: " + totalOfferVal + ",\t poll: " + totalPollVal + ",\t peek: " + totalPeekVal);
            System.err.println(" size: " + queue.size() + " \t speed: " + (totalOfferVal + totalPollVal + totalPeekVal) / (long)sleepTime);
            System.err.println("---------------------------------------------------------------------------------------");
            System.err.println("");
        }
    }

    private static void test2() {
        final CountDownLatch latch1 = new CountDownLatch(100);
        final CountDownLatch latch2 = new CountDownLatch(1000);
        new Thread(){

            @Override
            public void run() {
                for (int i = 0; i < 1000; ++i) {
                    queue.offer((Object)("item" + i));
                    latch1.countDown();
                    latch2.countDown();
                }
            }
        }.start();
        ClientQueuePerformanceBenchmark.assertOpenEventually((CountDownLatch)latch1);
        server.shutdown();
        ClientQueuePerformanceBenchmark.assertOpenEventually((CountDownLatch)latch2);
        System.err.println("size: " + queue.size());
    }
}

