/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.replicatedmap;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.MapEvent;
import com.hazelcast.core.ReplicatedMap;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.FalsePredicate;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@Category(value={QuickTest.class})
@RunWith(value=HazelcastParallelClassRunner.class)
public class ClientReplicatedMapListenerTest
extends HazelcastTestSupport {
    private TestHazelcastFactory factory = new TestHazelcastFactory();

    @After
    public void tearDown() {
        this.factory.terminateAll();
    }

    @Test
    public void testEntryAdded() {
        ReplicatedMap<Object, Object> replicatedMap = this.createClusterAndGetRandomReplicatedMap();
        final EventCountingListener listener = new EventCountingListener();
        replicatedMap.addEntryListener((EntryListener)listener);
        replicatedMap.put((Object)1, (Object)1);
        ClientReplicatedMapListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)1L, (long)listener.addCount.get());
            }
        });
    }

    @Test
    public void testEntryUpdated() {
        ReplicatedMap<Object, Object> replicatedMap = this.createClusterAndGetRandomReplicatedMap();
        final EventCountingListener listener = new EventCountingListener();
        replicatedMap.addEntryListener((EntryListener)listener);
        replicatedMap.put((Object)1, (Object)1);
        replicatedMap.put((Object)1, (Object)2);
        ClientReplicatedMapListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)1L, (long)listener.updateCount.get());
            }
        });
    }

    @Test
    public void testEntryRemoved() {
        ReplicatedMap<Object, Object> replicatedMap = this.createClusterAndGetRandomReplicatedMap();
        final EventCountingListener listener = new EventCountingListener();
        replicatedMap.addEntryListener((EntryListener)listener);
        replicatedMap.put((Object)1, (Object)1);
        replicatedMap.remove((Object)1);
        ClientReplicatedMapListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)1L, (long)listener.removeCount.get());
            }
        });
    }

    @Test
    public void testMapClear() {
        ReplicatedMap<Object, Object> replicatedMap = this.createClusterAndGetRandomReplicatedMap();
        final EventCountingListener listener = new EventCountingListener();
        replicatedMap.addEntryListener((EntryListener)listener);
        replicatedMap.put((Object)1, (Object)1);
        replicatedMap.clear();
        ClientReplicatedMapListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)1L, (long)listener.mapClearCount.get());
            }
        });
    }

    @Test
    public void testListenToKeyForEntryAdded() {
        ReplicatedMap<Object, Object> replicatedMap = this.createClusterAndGetRandomReplicatedMap();
        final EventCountingListener listener = new EventCountingListener();
        replicatedMap.addEntryListener((EntryListener)listener, (Object)1);
        replicatedMap.put((Object)1, (Object)1);
        replicatedMap.put((Object)2, (Object)2);
        ClientReplicatedMapListenerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)1L, (long)listener.keys.size());
                Assert.assertEquals((Object)1, (Object)listener.keys.peek());
                Assert.assertEquals((long)1L, (long)listener.addCount.get());
            }
        });
    }

    @Test
    public void testListenWithPredicate() {
        ReplicatedMap<Object, Object> replicatedMap = this.createClusterAndGetRandomReplicatedMap();
        final EventCountingListener listener = new EventCountingListener();
        replicatedMap.addEntryListener((EntryListener)listener, (Predicate)FalsePredicate.INSTANCE);
        replicatedMap.put((Object)2, (Object)2);
        ClientReplicatedMapListenerTest.assertTrueFiveSeconds((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)0L, (long)listener.addCount.get());
            }
        });
    }

    private ReplicatedMap<Object, Object> createClusterAndGetRandomReplicatedMap() {
        this.factory.newHazelcastInstance();
        HazelcastInstance client = this.factory.newHazelcastClient();
        String mapName = ClientReplicatedMapListenerTest.randomMapName();
        return client.getReplicatedMap(mapName);
    }

    public class EventCountingListener
    implements EntryListener<Object, Object> {
        final ConcurrentLinkedQueue<Object> keys = new ConcurrentLinkedQueue();
        final AtomicLong addCount = new AtomicLong();
        final AtomicLong removeCount = new AtomicLong();
        final AtomicLong updateCount = new AtomicLong();
        final AtomicLong evictCount = new AtomicLong();
        final AtomicLong mapClearCount = new AtomicLong();
        final AtomicLong mapEvictCount = new AtomicLong();

        EventCountingListener() {
        }

        public void entryAdded(EntryEvent<Object, Object> event) {
            this.keys.add(event.getKey());
            this.addCount.incrementAndGet();
        }

        public void entryRemoved(EntryEvent<Object, Object> event) {
            this.keys.add(event.getKey());
            this.removeCount.incrementAndGet();
        }

        public void entryUpdated(EntryEvent<Object, Object> event) {
            this.keys.add(event.getKey());
            this.updateCount.incrementAndGet();
        }

        public void entryEvicted(EntryEvent<Object, Object> event) {
            this.keys.add(event.getKey());
            this.evictCount.incrementAndGet();
        }

        public void mapEvicted(MapEvent event) {
            this.mapEvictCount.incrementAndGet();
        }

        public void mapCleared(MapEvent event) {
            this.mapClearCount.incrementAndGet();
        }

        public String toString() {
            return "EventCountingListener{addCount=" + this.addCount + ", removeCount=" + this.removeCount + ", updateCount=" + this.updateCount + ", evictCount=" + this.evictCount + ", mapClearCount=" + this.mapClearCount + ", mapEvictCount=" + this.mapEvictCount + '}';
        }
    }
}

