/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.aws.AWSClient;
import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.spi.impl.AwsAddressProvider;
import com.hazelcast.logging.Logger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.Address;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collection;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class AwsAddressProviderTest {
    private static final String PRIVATE_IP_ADDRESS = "127.0.0.1";
    private static final String PUBLIC_IP_ADDRESS = "198.51.100.1";
    private AWSClient awsClient;
    private LoggingService loggingService;
    private AwsAddressProvider provider;

    @Before
    public void setUp() throws Exception {
        HashMap<String, String> addresses = new HashMap<String, String>();
        addresses.put(PRIVATE_IP_ADDRESS, PUBLIC_IP_ADDRESS);
        this.awsClient = (AWSClient)Mockito.mock(AWSClient.class);
        Mockito.when((Object)this.awsClient.getAddresses()).thenReturn(addresses);
        this.loggingService = (LoggingService)Mockito.mock(LoggingService.class);
        Mockito.when((Object)this.loggingService.getLogger((Class)Matchers.eq(AwsAddressProvider.class))).thenReturn((Object)Logger.getLogger(AwsAddressProviderTest.class));
        this.provider = new AwsAddressProvider(this.awsClient, this.loggingService);
    }

    @Test
    public void testLoadAddresses() {
        Collection addresses = this.provider.loadAddresses();
        Assert.assertTrue((String)"Expected that at least one address is loaded", (addresses.size() > 0 ? 1 : 0) != 0);
        for (Address address : addresses) {
            Assert.assertEquals((Object)PRIVATE_IP_ADDRESS, (Object)address.getHost());
        }
    }

    @Test
    public void testLoadAddresses_whenExceptionIsThrown() throws Exception {
        Mockito.when((Object)this.awsClient.getAddresses()).thenThrow(new Throwable[]{new IllegalStateException("Expected exception")});
        Collection addresses = this.provider.loadAddresses();
        Assert.assertEquals((String)"Expected that no addresses are loaded", (long)0L, (long)addresses.size());
    }

    @Test
    public void testLoadAddresses_whenConfigIsIncomplete() {
        ClientAwsConfig config = new ClientAwsConfig();
        config.setEnabled(false);
        this.provider = new AwsAddressProvider(config, this.loggingService);
        Collection addresses = this.provider.loadAddresses();
        Assert.assertEquals((String)"Expected that no addresses are loaded", (long)0L, (long)addresses.size());
    }
}

