/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.aws.AWSClient;
import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.spi.impl.AwsAddressTranslator;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.Address;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.HashMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class AwsAddressTranslatorTest {
    private final Map<String, String> lookup = new HashMap<String, String>();
    private Address privateAddress;
    private Address publicAddress;
    private AWSClient awsClient;
    private ClientAwsConfig config;
    private LoggingService loggingService;
    private AwsAddressTranslator translator;

    @Before
    public void setUp() throws Exception {
        this.privateAddress = new Address("127.0.0.1", 5701);
        this.publicAddress = new Address("192.168.0.1", 5701);
        this.awsClient = (AWSClient)Mockito.mock(AWSClient.class);
        Mockito.when((Object)this.awsClient.getAddresses()).thenReturn(this.lookup);
        this.config = new ClientAwsConfig();
        this.config.setIamRole("anyRole");
        ILogger logger = Logger.getLogger(AwsAddressTranslatorTest.class);
        this.loggingService = (LoggingService)Mockito.mock(LoggingService.class);
        Mockito.when((Object)this.loggingService.getLogger((Class)Matchers.eq(AwsAddressTranslator.class))).thenReturn((Object)logger);
        this.translator = new AwsAddressTranslator(this.config, this.loggingService);
    }

    @Test
    public void testTranslate_whenInsideAws_thenReturnSameAddress() {
        this.config.setInsideAws(true);
        AwsAddressTranslator translator = new AwsAddressTranslator(this.config, this.loggingService);
        Address actual = translator.translate(this.privateAddress);
        Assert.assertEquals((Object)this.privateAddress, (Object)actual);
    }

    @Test
    public void testTranslate_whenAddressIsNull_thenReturnNull() {
        Address actual = this.translator.translate(null);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testTranslate_whenAddressIsMapped_thenReturnPublicAddress() {
        this.translator.getLookupTable().put(this.privateAddress.getHost(), this.publicAddress.getHost());
        Address actual = this.translator.translate(this.privateAddress);
        Assert.assertEquals((Object)this.publicAddress.getHost(), (Object)actual.getHost());
        Assert.assertEquals((long)this.privateAddress.getPort(), (long)actual.getPort());
    }

    @Test
    public void testTranslate_whenPublicAddress_thenReturnCachedValue() {
        this.translator.getLookupTable().put(this.privateAddress.getHost(), this.publicAddress.getHost());
        Address actual = this.translator.translate(this.publicAddress);
        Assert.assertEquals((Object)this.publicAddress.getHost(), (Object)actual.getHost());
        Assert.assertEquals((long)this.privateAddress.getPort(), (long)actual.getPort());
    }

    @Test
    public void testTranslate_whenNotMapped_thenRefresh() {
        this.translator = new AwsAddressTranslator(this.awsClient, this.config, this.loggingService);
        this.lookup.put(this.privateAddress.getHost(), this.publicAddress.getHost());
        Address actual = this.translator.translate(this.privateAddress);
        Assert.assertEquals((Object)this.publicAddress.getHost(), (Object)actual.getHost());
        Assert.assertEquals((long)this.privateAddress.getPort(), (long)actual.getPort());
    }

    @Test
    public void testTranslate_whenNotFound_thenReturnNull() {
        this.translator = new AwsAddressTranslator(this.awsClient, this.config, this.loggingService);
        Address actual = this.translator.translate(this.privateAddress);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testTranslate_whenPublicAddressIsInvalid_thenReturnNull() {
        this.translator.getLookupTable().put(this.privateAddress.getHost(), "invalidHost");
        Address actual = this.translator.translate(this.privateAddress);
        Assert.assertNull((Object)actual);
    }

    @Test
    public void testRefresh_whenException_thenLogWarning() throws Exception {
        Mockito.when((Object)this.awsClient.getAddresses()).thenThrow(new Throwable[]{new RuntimeException("expected exception!")});
        this.translator = new AwsAddressTranslator(this.awsClient, this.config, this.loggingService);
        this.translator.refresh();
    }
}

