/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.spi.impl.AbstractClientInvocationService;
import com.hazelcast.client.spi.impl.ClientResponseHandler;
import com.hazelcast.client.spi.impl.ClientResponseHandlerSupplier;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.ClientTestSupport;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientResponseHandlerSupplierTest
extends ClientTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @Before
    public void before() {
        this.hazelcastFactory.newHazelcastInstance();
    }

    @After
    public void after() {
        this.hazelcastFactory.terminateAll();
    }

    @Test(expected=IllegalArgumentException.class)
    public void whenNegativeResponseThreads() {
        this.getResponseHandler(-1);
    }

    @Test
    public void whenZeroResponseThreads() {
        ClientResponseHandler handler = this.getResponseHandler(0);
        ClientResponseHandlerSupplierTest.assertInstanceOf(ClientResponseHandlerSupplier.SyncResponseHandler.class, (Object)handler);
    }

    @Test
    public void whenOneResponseThreads() {
        ClientResponseHandler handler = this.getResponseHandler(1);
        ClientResponseHandlerSupplierTest.assertInstanceOf(ClientResponseHandlerSupplier.AsyncSingleThreadedResponseHandler.class, (Object)handler);
    }

    @Test
    public void whenMultipleResponseThreads() {
        ClientResponseHandler handler = this.getResponseHandler(2);
        ClientResponseHandlerSupplierTest.assertInstanceOf(ClientResponseHandlerSupplier.AsyncMultiThreadedResponseHandler.class, (Object)handler);
    }

    private ClientResponseHandler getResponseHandler(int threadCount) {
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(new ClientConfig().setProperty(ClientProperty.RESPONSE_THREAD_COUNT.getName(), "" + threadCount));
        HazelcastClientInstanceImpl clientInstanceImpl = this.getHazelcastClientInstanceImpl(client);
        AbstractClientInvocationService invocationService = (AbstractClientInvocationService)clientInstanceImpl.getInvocationService();
        ClientResponseHandlerSupplier responseHandlerSupplier = new ClientResponseHandlerSupplier(invocationService);
        return responseHandlerSupplier.get();
    }
}

