/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.stress;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.stress.StressTestSupport;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IAtomicLong;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.NightlyTest;
import java.util.HashSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={NightlyTest.class})
public class AtomicLongUpdateStressTest
extends StressTestSupport {
    public static final int CLIENT_THREAD_COUNT = 5;
    public static final int REFERENCE_COUNT = 10000;
    private HazelcastInstance client;
    private IAtomicLong[] references;
    private StressThread[] stressThreads;

    @Override
    @Before
    public void setUp() {
        int k;
        super.setUp();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setRedoOperation(true);
        this.client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        this.references = new IAtomicLong[10000];
        for (k = 0; k < this.references.length; ++k) {
            this.references[k] = this.client.getAtomicLong("atomicreference:" + k);
        }
        this.stressThreads = new StressThread[5];
        for (k = 0; k < this.stressThreads.length; ++k) {
            this.stressThreads[k] = new StressThread();
            this.stressThreads[k].start();
        }
    }

    @Override
    @After
    public void tearDown() {
        super.tearDown();
        if (this.client != null) {
            this.client.shutdown();
        }
    }

    @Test
    @Ignore
    public void testChangingCluster() {
        this.test(true);
    }

    @Test(timeout=600000L)
    public void testFixedCluster() {
        this.test(false);
    }

    public void test(boolean clusterChangeEnabled) {
        this.setClusterChangeEnabled(clusterChangeEnabled);
        this.startAndWaitForTestCompletion();
        this.joinAll(this.stressThreads);
        this.assertNoUpdateFailures();
    }

    private void assertNoUpdateFailures() {
        int[] increments = new int[10000];
        for (StressThread t : this.stressThreads) {
            t.addIncrements(increments);
        }
        HashSet<Integer> failedKeys = new HashSet<Integer>();
        for (int k = 0; k < 10000; ++k) {
            long expectedValue = increments[k];
            long foundValue = this.references[k].get();
            if (expectedValue == foundValue) continue;
            failedKeys.add(k);
        }
        if (failedKeys.isEmpty()) {
            return;
        }
        int index = 1;
        for (Integer key : failedKeys) {
            System.err.println("Failed write: " + index + " found:" + this.references[key].get() + " expected:" + increments[key]);
            ++index;
        }
        Assert.fail((String)("There are failed writes, number of failures:" + failedKeys.size()));
    }

    public class StressThread
    extends StressTestSupport.TestThread {
        private final int[] increments;

        public StressThread() {
            super(AtomicLongUpdateStressTest.this);
            this.increments = new int[10000];
        }

        @Override
        public void doRun() throws Exception {
            while (!AtomicLongUpdateStressTest.this.isStopped()) {
                int index = this.random.nextInt(10000);
                int increment = this.random.nextInt(100);
                int n = index;
                this.increments[n] = this.increments[n] + increment;
                IAtomicLong reference = AtomicLongUpdateStressTest.this.references[index];
                reference.addAndGet((long)increment);
            }
        }

        public void addIncrements(int[] increments) {
            for (int k = 0; k < increments.length; ++k) {
                int n = k;
                increments[n] = increments[n] + this.increments[k];
            }
        }
    }
}

