/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.stress;

import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastTestSupport;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class StressTestSupport
extends HazelcastTestSupport {
    public static final int RUNNING_TIME_SECONDS = 180;
    public static final int CLUSTER_SIZE = 6;
    public static final int KILL_DELAY_SECONDS = 10;
    private final List<HazelcastInstance> instances = new CopyOnWriteArrayList<HazelcastInstance>();
    private CountDownLatch startLatch;
    private KillMemberThread killMemberThread;
    private volatile boolean stopOnError = true;
    private volatile boolean stopTest = false;
    private boolean clusterChangeEnabled = true;
    public static final AtomicLong ID_GENERATOR = new AtomicLong(1L);

    @Before
    public void setUp() {
        this.startLatch = new CountDownLatch(1);
        for (int k = 0; k < 6; ++k) {
            HazelcastInstance hz = Hazelcast.newHazelcastInstance((Config)this.createClusterConfig());
            this.instances.add(hz);
        }
    }

    public void setClusterChangeEnabled(boolean membershutdownEnabled) {
        this.clusterChangeEnabled = membershutdownEnabled;
    }

    public Config createClusterConfig() {
        return new Config();
    }

    @After
    public void tearDown() {
        this.stopTest = true;
        if (this.killMemberThread != null) {
            try {
                this.killMemberThread.join(TimeUnit.SECONDS.toMillis(40L));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (HazelcastInstance hz : this.instances) {
            try {
                hz.getLifecycleService().terminate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public final boolean startAndWaitForTestCompletion() {
        System.out.println("Cluster change enabled:" + this.clusterChangeEnabled);
        if (this.clusterChangeEnabled) {
            this.killMemberThread = new KillMemberThread();
            this.killMemberThread.start();
        }
        System.out.println("==================================================================");
        System.out.println("Test started.");
        System.out.println("==================================================================");
        this.startLatch.countDown();
        for (int k = 1; k <= 180; ++k) {
            try {
                Thread.sleep(TimeUnit.SECONDS.toMillis(1L));
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            float percent = (float)k * 100.0f / 180.0f;
            System.out.printf("%.1f Running for %s of %s seconds\n", Float.valueOf(percent), k, 180);
            if (!this.stopTest) continue;
            System.err.println("==================================================================");
            System.err.println("Test ended premature!");
            System.err.println("==================================================================");
            return false;
        }
        System.out.println("==================================================================");
        System.out.println("Test completed.");
        System.out.println("==================================================================");
        this.stopTest();
        return true;
    }

    protected final void setStopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
    }

    protected final void stopTest() {
        this.stopTest = true;
    }

    protected final boolean isStopped() {
        return this.stopTest;
    }

    public final void assertNoErrors(TestThread ... threads) {
        for (TestThread thread : threads) {
            thread.assertNoError();
        }
    }

    public final void joinAll(TestThread ... threads) {
        for (TestThread t : threads) {
            try {
                t.join(60000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while joining thread:" + t);
            }
            if (!t.isAlive()) continue;
            System.err.println("Could not join Thread:" + t.getName() + ", it is still alive");
            for (StackTraceElement e : t.getStackTrace()) {
                System.err.println("\tat " + e);
            }
            throw new RuntimeException("Could not join thread:" + t + ", thread is still alive");
        }
        this.assertNoErrors(threads);
    }

    public class KillMemberThread
    extends TestThread {
        @Override
        public void doRun() throws Exception {
            while (!StressTestSupport.this.stopTest) {
                try {
                    Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                int index = this.random.nextInt(6);
                HazelcastInstance instance = (HazelcastInstance)StressTestSupport.this.instances.remove(index);
                instance.shutdown();
                HazelcastInstance newInstance = Hazelcast.newHazelcastInstance((Config)StressTestSupport.this.createClusterConfig());
                StressTestSupport.this.instances.add(newInstance);
            }
        }
    }

    public abstract class TestThread
    extends Thread {
        private volatile Throwable error;
        protected final Random random = new Random();

        public TestThread() {
            this.setName(this.getClass().getName() + "" + ID_GENERATOR.getAndIncrement());
        }

        @Override
        public final void run() {
            try {
                StressTestSupport.this.startLatch.await();
                this.doRun();
            }
            catch (Throwable t) {
                if (StressTestSupport.this.stopOnError) {
                    StressTestSupport.this.stopTest();
                }
                t.printStackTrace();
                this.error = t;
            }
        }

        public final void assertNoError() {
            Assert.assertNull((String)(this.getName() + " encountered an error"), (Object)this.error);
        }

        public abstract void doRun() throws Exception;
    }
}

