/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.test;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.AbstractHazelcastClassRunner;
import com.hazelcast.test.TestAwareInstanceFactory;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TestAwareClientFactory
extends TestAwareInstanceFactory {
    protected final Map<String, List<HazelcastInstance>> perMethodClients = new ConcurrentHashMap<String, List<HazelcastInstance>>();

    public HazelcastInstance newHazelcastClient(ClientConfig config) {
        if (config == null) {
            config = new ClientConfig();
        }
        config.getGroupConfig().setName(AbstractHazelcastClassRunner.getTestMethodName());
        List members = this.getOrInitInstances(this.perMethodMembers);
        if (members.isEmpty()) {
            throw new IllegalStateException("Members have to be created first");
        }
        ClientNetworkConfig networkConfig = config.getNetworkConfig();
        for (HazelcastInstance member : members) {
            networkConfig.addAddress(new String[]{"127.0.0.1:" + TestAwareClientFactory.getPort((HazelcastInstance)member)});
        }
        HazelcastInstance hz = HazelcastClient.newHazelcastClient((ClientConfig)config);
        this.getOrInitInstances(this.perMethodClients).add(hz);
        return hz;
    }

    public void terminateAll() {
        this.shutdownInstances(this.perMethodClients.remove(AbstractHazelcastClassRunner.getTestMethodName()));
        super.terminateAll();
    }
}

