/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.topic;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.RingbufferConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.topic.ReliableMessageListener;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class Issue7317Test {
    static final String smallRB = "foo";
    static final int smallRBCapacity = 3;
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;

    @Before
    public void setup() {
        Config serverConfig = new Config();
        RingbufferConfig rbConf = new RingbufferConfig(smallRB);
        rbConf.setCapacity(3);
        serverConfig.addRingBufferConfig(rbConf);
        this.hazelcastFactory.newHazelcastInstance(serverConfig);
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void registerListenerOnStaleSequenceClientServer() throws InterruptedException {
        List<String> messages = Arrays.asList("a", "b", "c", "d", "e");
        CountDownLatch cdl = new CountDownLatch(3);
        ITopic rTopic = this.client.getReliableTopic(smallRB);
        for (String message : messages) {
            rTopic.publish((Object)message);
        }
        Issue7317MessageListener listener = new Issue7317MessageListener(messages, cdl);
        String reg = rTopic.addMessageListener((MessageListener)listener);
        Assert.assertTrue((boolean)cdl.await(5L, TimeUnit.SECONDS));
        rTopic.removeMessageListener(reg);
    }

    static class Issue7317MessageListener
    implements ReliableMessageListener<String> {
        private final List<String> messages;
        private final CountDownLatch cdl;
        private long seq;

        public Issue7317MessageListener(List<String> messages, CountDownLatch cdl) {
            this.messages = messages;
            this.cdl = cdl;
        }

        public void onMessage(Message<String> msg) {
            Assert.assertEquals((long)((long)this.messages.size() - this.cdl.getCount()), (long)((int)this.seq));
            Assert.assertEquals((Object)this.messages.get((int)this.seq), (Object)msg.getMessageObject());
            this.cdl.countDown();
        }

        public long retrieveInitialSequence() {
            return 0L;
        }

        public void storeSequence(long sequence) {
            this.seq = sequence;
        }

        public boolean isLossTolerant() {
            return true;
        }

        public boolean isTerminal(Throwable failure) {
            return true;
        }
    }
}

