/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.TransactionalQueue;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.transaction.TransactionContext;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientTxnQueueTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
    }

    @Test
    public void testTransactionalOfferPoll() {
        String item = "offered";
        String queueName = HazelcastTestSupport.randomString();
        IQueue queue = this.client.getQueue(queueName);
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalQueue txnQueue = context.getQueue(queueName);
        txnQueue.offer((Object)"offered");
        Assert.assertEquals((Object)"offered", (Object)txnQueue.poll());
        context.commitTransaction();
    }

    @Test
    public void testQueueSizeAfterTxnOfferPoll() {
        String item = "offered";
        String queueName = HazelcastTestSupport.randomString();
        IQueue queue = this.client.getQueue(queueName);
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalQueue txnQueue = context.getQueue(queueName);
        txnQueue.offer((Object)"offered");
        txnQueue.poll();
        context.commitTransaction();
        Assert.assertEquals((long)0L, (long)queue.size());
    }

    @Test
    public void testTransactionalOfferTake() throws InterruptedException {
        String item = "offered";
        String queueName = HazelcastTestSupport.randomString();
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalQueue txnQueue = context.getQueue(queueName);
        Assert.assertTrue((boolean)txnQueue.offer((Object)"offered"));
        Assert.assertEquals((long)1L, (long)txnQueue.size());
        Assert.assertEquals((Object)"offered", (Object)txnQueue.take());
        context.commitTransaction();
    }

    @Test
    public void testTransactionalQueueGetsOfferedItems_whenBlockedOnPoll() throws InterruptedException {
        String item = "offered1";
        String queueName = HazelcastTestSupport.randomString();
        final IQueue queue1 = this.client.getQueue(queueName);
        final CountDownLatch justBeforeBlocked = new CountDownLatch(1);
        new Thread(){

            @Override
            public void run() {
                try {
                    justBeforeBlocked.await();
                    HazelcastTestSupport.sleepSeconds((int)1);
                    queue1.offer((Object)"offered1");
                }
                catch (InterruptedException e) {
                    Assert.fail((String)("failed" + e));
                }
            }
        }.start();
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalQueue txnQueue1 = context.getQueue(queueName);
        justBeforeBlocked.countDown();
        Object result = txnQueue1.poll(5L, TimeUnit.SECONDS);
        Assert.assertEquals((String)"TransactionalQueue while blocked in pol should get item offered from client queue", (Object)"offered1", (Object)result);
        context.commitTransaction();
    }

    @Test
    public void testTransactionalPeek() {
        String item = "offered";
        String queunName = HazelcastTestSupport.randomString();
        IQueue queue = this.client.getQueue(queunName);
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalQueue txnQueue = context.getQueue(queunName);
        txnQueue.offer((Object)"offered");
        Assert.assertEquals((Object)"offered", (Object)txnQueue.peek());
        Assert.assertEquals((Object)"offered", (Object)txnQueue.peek());
        context.commitTransaction();
    }

    @Test
    public void testTransactionalOfferRoleBack() {
        String name = HazelcastTestSupport.randomString();
        IQueue queue = this.client.getQueue(name);
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalQueue qTxn = context.getQueue(name);
        qTxn.offer((Object)"ITEM");
        context.rollbackTransaction();
        Assert.assertEquals((long)0L, (long)queue.size());
    }

    @Test
    public void testTransactionalQueueSize() {
        String item = "offered";
        String name = HazelcastTestSupport.randomString();
        IQueue queue = this.client.getQueue(name);
        queue.offer((Object)"offered");
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalQueue txnQueue = context.getQueue(name);
        txnQueue.offer((Object)"offered");
        Assert.assertEquals((long)2L, (long)txnQueue.size());
        context.rollbackTransaction();
    }

    @Test
    public void testTransactionalOfferAndPollWithTimeout() throws InterruptedException {
        String item = "offered";
        String name = HazelcastTestSupport.randomString();
        TransactionContext context = this.client.newTransactionContext();
        context.beginTransaction();
        TransactionalQueue txnQueue = context.getQueue(name);
        Assert.assertTrue((boolean)txnQueue.offer((Object)"offered"));
        Assert.assertEquals((long)1L, (long)txnQueue.size());
        Assert.assertEquals((Object)"offered", (Object)txnQueue.poll(5L, TimeUnit.SECONDS));
        context.commitTransaction();
    }
}

