/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.txn.serialization;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.client.txn.serialization.SampleIdentified;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.TransactionalMap;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.transaction.TransactionContext;
import java.util.Collection;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class TxnMapDeserializationTest
extends HazelcastTestSupport {
    private static final Object EXISTING_KEY = new SampleIdentified(1);
    private static final Object EXISTING_VALUE = new SampleIdentified(2);
    private static final Object NEW_KEY = new SampleIdentified(3);
    private static final Object NEW_VALUE = new SampleIdentified(4);
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private TransactionalMap<Object, Object> map;
    private TransactionContext context;

    @Before
    public void setup() {
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getSerializationConfig().addDataSerializableFactory(1, new DataSerializableFactory(){

            public IdentifiedDataSerializable create(int typeId) {
                return new SampleIdentified();
            }
        });
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        client.getMap("test").put(EXISTING_KEY, EXISTING_VALUE);
        client.getMap("test").get(EXISTING_KEY);
        this.context = client.newTransactionContext();
        this.context.beginTransaction();
        this.map = this.context.getMap("test");
    }

    @After
    public void tearDown() {
        if (this.context != null) {
            this.context.commitTransaction();
        }
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testMapUpdate() {
        TestCase.assertEquals((Object)EXISTING_VALUE, (Object)this.map.put(EXISTING_KEY, NEW_VALUE));
    }

    @Test
    public void testMapPut() {
        TestCase.assertNull((Object)this.map.put(NEW_KEY, NEW_VALUE));
    }

    @Test
    public void testMapPutTwiceToSameKey() {
        TestCase.assertNull((Object)this.map.put(NEW_KEY, NEW_VALUE));
        TestCase.assertEquals((Object)NEW_VALUE, (Object)this.map.put(NEW_KEY, NEW_VALUE));
    }

    @Test
    public void testMapPutGet() {
        TestCase.assertEquals((Object)EXISTING_VALUE, (Object)this.map.put(EXISTING_KEY, NEW_VALUE));
        TestCase.assertEquals((Object)NEW_VALUE, (Object)this.map.get(EXISTING_KEY));
    }

    @Test
    public void testMapGet() {
        TestCase.assertEquals((Object)EXISTING_VALUE, (Object)this.map.get(EXISTING_KEY));
    }

    @Test
    public void testMapValues() {
        TxnMapDeserializationTest.assertContains((Collection)this.map.values(), (Object)EXISTING_VALUE);
    }

    @Test
    public void testMapKeySet() {
        TxnMapDeserializationTest.assertContains((Collection)this.map.keySet(), (Object)EXISTING_KEY);
    }

    @Test
    public void testMapContainsKey() {
        TestCase.assertTrue((boolean)this.map.containsKey(EXISTING_KEY));
    }

    @Test
    public void testMapRemove() {
        TestCase.assertEquals((Object)EXISTING_VALUE, (Object)this.map.remove(EXISTING_KEY));
    }

    @Test
    public void testMapRemoveIfEqual() {
        TestCase.assertTrue((boolean)this.map.remove(EXISTING_KEY, EXISTING_VALUE));
    }

    @Test
    public void testMapReplace() {
        TestCase.assertTrue((boolean)this.map.replace(EXISTING_KEY, EXISTING_VALUE, NEW_VALUE));
    }

    @Test
    public void testMapReplaceAndGet() {
        TestCase.assertEquals((Object)EXISTING_VALUE, (Object)this.map.replace(EXISTING_KEY, NEW_VALUE));
    }

    @Test
    public void testGetForUpdate() {
        TestCase.assertEquals((Object)EXISTING_VALUE, (Object)this.map.getForUpdate(EXISTING_KEY));
    }
}

