/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.usercodedeployment;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientUserCodeDeploymentConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.map.EntryProcessor;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.util.FilteringClassLoader;
import java.io.FileNotFoundException;
import java.util.Collections;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import usercodedeployment.IncrementingEntryProcessor;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientUserCodeDeploymentExceptionTest
extends HazelcastTestSupport {
    private TestHazelcastFactory factory = new TestHazelcastFactory();

    @After
    public void tearDown() throws Exception {
        this.factory.terminateAll();
    }

    @Test
    public void testUserCodeDeploymentIsDisabledByDefaultOnClient() {
        ClientConfig clientConfig = new ClientConfig();
        Config config = this.createNodeConfig();
        config.getUserCodeDeploymentConfig().setEnabled(true);
        IncrementingEntryProcessor incrementingEntryProcessor = new IncrementingEntryProcessor();
        this.factory.newHazelcastInstance(config);
        HazelcastInstance client = this.factory.newHazelcastClient(clientConfig);
        IMap map = client.getMap(ClientUserCodeDeploymentExceptionTest.randomName());
        try {
            map.executeOnEntries((EntryProcessor)incrementingEntryProcessor);
            TestCase.assertTrue((boolean)false);
        }
        catch (HazelcastSerializationException e) {
            Assert.assertEquals(ClassNotFoundException.class, e.getCause().getClass());
        }
    }

    private Config createNodeConfig() {
        Config i2Config = new Config();
        FilteringClassLoader filteringCL = new FilteringClassLoader(Collections.singletonList("usercodedeployment"), null);
        i2Config.setClassLoader((ClassLoader)filteringCL);
        return i2Config;
    }

    private ClientConfig createClientConfig() {
        ClientConfig config = new ClientConfig();
        ClientUserCodeDeploymentConfig clientUserCodeDeploymentConfig = new ClientUserCodeDeploymentConfig();
        clientUserCodeDeploymentConfig.addClass("usercodedeployment.IncrementingEntryProcessor");
        config.setUserCodeDeploymentConfig(clientUserCodeDeploymentConfig.setEnabled(true));
        return config;
    }

    @Test(expected=IllegalStateException.class)
    public void testUserCodeDeployment_serverIsNotEnabled() {
        ClientConfig clientConfig = this.createClientConfig();
        clientConfig.getUserCodeDeploymentConfig().setEnabled(true);
        Config config = this.createNodeConfig();
        this.factory.newHazelcastInstance(config);
        this.factory.newHazelcastClient(clientConfig);
    }

    @Test(expected=IllegalStateException.class)
    public void testClientsWithConflictingClassRepresentations() {
        Config config = this.createNodeConfig();
        config.getUserCodeDeploymentConfig().setEnabled(true);
        this.factory.newHazelcastInstance(config);
        ClientConfig clientConfig = new ClientConfig();
        ClientUserCodeDeploymentConfig clientUserCodeDeploymentConfig = new ClientUserCodeDeploymentConfig();
        clientUserCodeDeploymentConfig.addJar("IncrementingEntryProcessor.jar").setEnabled(true);
        clientConfig.setUserCodeDeploymentConfig(clientUserCodeDeploymentConfig);
        this.factory.newHazelcastClient(clientConfig);
        clientConfig = new ClientConfig();
        clientUserCodeDeploymentConfig = new ClientUserCodeDeploymentConfig();
        clientUserCodeDeploymentConfig.addJar("IncrementingEntryProcessorConflicting.jar").setEnabled(true);
        clientConfig.setUserCodeDeploymentConfig(clientUserCodeDeploymentConfig);
        this.factory.newHazelcastClient(clientConfig);
    }

    @Test(expected=ClassNotFoundException.class)
    public void testClientsWith_wrongClassName() throws Throwable {
        Config config = this.createNodeConfig();
        config.getUserCodeDeploymentConfig().setEnabled(true);
        this.factory.newHazelcastInstance(config);
        ClientConfig clientConfig = new ClientConfig();
        ClientUserCodeDeploymentConfig clientUserCodeDeploymentConfig = new ClientUserCodeDeploymentConfig();
        clientUserCodeDeploymentConfig.addClass("NonExisting.class").setEnabled(true);
        clientConfig.setUserCodeDeploymentConfig(clientUserCodeDeploymentConfig);
        try {
            this.factory.newHazelcastClient(clientConfig);
        }
        catch (HazelcastException e) {
            throw e.getCause();
        }
    }

    @Test(expected=FileNotFoundException.class)
    public void testClientsWith_wrongJarPath() throws Throwable {
        Config config = this.createNodeConfig();
        config.getUserCodeDeploymentConfig().setEnabled(true);
        this.factory.newHazelcastInstance(config);
        ClientConfig clientConfig = new ClientConfig();
        ClientUserCodeDeploymentConfig clientUserCodeDeploymentConfig = new ClientUserCodeDeploymentConfig();
        clientUserCodeDeploymentConfig.addJar("NonExisting.jar").setEnabled(true);
        clientConfig.setUserCodeDeploymentConfig(clientUserCodeDeploymentConfig);
        try {
            this.factory.newHazelcastClient(clientConfig);
        }
        catch (HazelcastException e) {
            throw e.getCause();
        }
    }
}

