/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.cp.internal.datastructures.atomicref;

import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CPAtomicRefApplyCodec;
import com.hazelcast.client.impl.protocol.codec.CPAtomicRefCompareAndSetCodec;
import com.hazelcast.client.impl.protocol.codec.CPAtomicRefContainsCodec;
import com.hazelcast.client.impl.protocol.codec.CPAtomicRefGetCodec;
import com.hazelcast.client.impl.protocol.codec.CPAtomicRefSetCodec;
import com.hazelcast.client.impl.protocol.codec.CPGroupDestroyCPObjectCodec;
import com.hazelcast.client.spi.ClientContext;
import com.hazelcast.client.spi.ClientProxy;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.util.ClientDelegatingFuture;
import com.hazelcast.core.IAtomicReference;
import com.hazelcast.core.IFunction;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.RaftGroupId;
import com.hazelcast.cp.internal.datastructures.atomicref.operation.ApplyOp;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.util.Preconditions;

class RaftAtomicRefProxy<T>
extends ClientProxy
implements IAtomicReference<T> {
    private static final ClientMessageDecoder COMPARE_AND_SET_DECODER = new ClientMessageDecoder(){

        public Boolean decodeClientMessage(ClientMessage clientMessage) {
            return CPAtomicRefCompareAndSetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder GET_DECODER = new ClientMessageDecoder(){

        public Data decodeClientMessage(ClientMessage clientMessage) {
            return CPAtomicRefGetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder CONTAINS_DECODER = new ClientMessageDecoder(){

        public Boolean decodeClientMessage(ClientMessage clientMessage) {
            return CPAtomicRefContainsCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder SET_DECODER = new ClientMessageDecoder(){

        public Data decodeClientMessage(ClientMessage clientMessage) {
            return CPAtomicRefGetCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private static final ClientMessageDecoder APPLY_DECODER = new ClientMessageDecoder(){

        public Data decodeClientMessage(ClientMessage clientMessage) {
            return CPAtomicRefApplyCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };
    private final RaftGroupId groupId;
    private final String objectName;

    RaftAtomicRefProxy(ClientContext context, RaftGroupId groupId, String proxyName, String objectName) {
        super("hz:raft:atomicRefService", proxyName, context);
        this.groupId = groupId;
        this.objectName = objectName;
    }

    public boolean compareAndSet(T expect, T update) {
        return (Boolean)this.compareAndSetAsync(expect, update).join();
    }

    public T get() {
        return (T)this.getAsync().join();
    }

    public void set(T newValue) {
        this.setAsync(newValue).join();
    }

    public T getAndSet(T newValue) {
        return (T)this.getAndSetAsync(newValue).join();
    }

    public T setAndGet(T update) {
        this.setAsync(update).join();
        return update;
    }

    public boolean isNull() {
        return (Boolean)this.isNullAsync().join();
    }

    public void clear() {
        this.clearAsync().join();
    }

    public boolean contains(T value) {
        return (Boolean)this.containsAsync(value).join();
    }

    public void alter(IFunction<T, T> function) {
        this.alterAsync(function).join();
    }

    public T alterAndGet(IFunction<T, T> function) {
        return (T)this.alterAndGetAsync(function).join();
    }

    public T getAndAlter(IFunction<T, T> function) {
        return (T)this.getAndAlterAsync(function).join();
    }

    public <R> R apply(IFunction<T, R> function) {
        return (R)this.applyAsync(function).join();
    }

    public InternalCompletableFuture<Boolean> compareAndSetAsync(T expect, T update) {
        Data expectedData = this.getContext().getSerializationService().toData(expect);
        Data newData = this.getContext().getSerializationService().toData(update);
        ClientMessage request = CPAtomicRefCompareAndSetCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName, (Data)expectedData, (Data)newData);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Boolean>(future, this.getSerializationService(), COMPARE_AND_SET_DECODER);
    }

    public InternalCompletableFuture<T> getAsync() {
        ClientMessage request = CPAtomicRefGetCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture(future, this.getSerializationService(), GET_DECODER);
    }

    public InternalCompletableFuture<Void> setAsync(T newValue) {
        Data data = this.getContext().getSerializationService().toData(newValue);
        ClientMessage request = CPAtomicRefSetCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName, (Data)data, (boolean)false);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Void>(future, this.getSerializationService(), SET_DECODER);
    }

    public InternalCompletableFuture<T> getAndSetAsync(T newValue) {
        Data data = this.getContext().getSerializationService().toData(newValue);
        ClientMessage request = CPAtomicRefSetCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName, (Data)data, (boolean)true);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture(future, this.getSerializationService(), SET_DECODER);
    }

    public InternalCompletableFuture<Boolean> isNullAsync() {
        return this.containsAsync((T)null);
    }

    public InternalCompletableFuture<Void> clearAsync() {
        return this.setAsync((T)null);
    }

    public InternalCompletableFuture<Boolean> containsAsync(T expected) {
        Data data = this.getContext().getSerializationService().toData(expected);
        ClientMessage request = CPAtomicRefContainsCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName, (Data)data);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture<Boolean>(future, this.getSerializationService(), CONTAINS_DECODER);
    }

    public InternalCompletableFuture<Void> alterAsync(IFunction<T, T> function) {
        return this.invokeApply(function, ApplyOp.ReturnValueType.NO_RETURN_VALUE, true);
    }

    public InternalCompletableFuture<T> alterAndGetAsync(IFunction<T, T> function) {
        return this.invokeApply(function, ApplyOp.ReturnValueType.RETURN_NEW_VALUE, true);
    }

    public InternalCompletableFuture<T> getAndAlterAsync(IFunction<T, T> function) {
        return this.invokeApply(function, ApplyOp.ReturnValueType.RETURN_OLD_VALUE, true);
    }

    public <R> InternalCompletableFuture<R> applyAsync(IFunction<T, R> function) {
        return this.invokeApply(function, ApplyOp.ReturnValueType.RETURN_NEW_VALUE, false);
    }

    @Override
    public void onDestroy() {
        ClientMessage request = CPGroupDestroyCPObjectCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.getServiceName(), (String)this.objectName);
        new ClientInvocation(this.getClient(), request, this.name).invoke().join();
    }

    @Override
    public String getPartitionKey() {
        throw new UnsupportedOperationException();
    }

    public CPGroupId getGroupId() {
        return this.groupId;
    }

    private <T2, T3> InternalCompletableFuture<T3> invokeApply(IFunction<T, T2> function, ApplyOp.ReturnValueType returnValueType, boolean alter) {
        Preconditions.checkTrue((function != null ? 1 : 0) != 0, (String)"Function cannot be null");
        Data data = this.getContext().getSerializationService().toData(function);
        ClientMessage request = CPAtomicRefApplyCodec.encodeRequest((RaftGroupId)this.groupId, (String)this.objectName, (Data)data, (int)returnValueType.value(), (boolean)alter);
        ClientInvocationFuture future = new ClientInvocation(this.getClient(), request, this.name).invoke();
        return new ClientDelegatingFuture(future, this.getSerializationService(), APPLY_DECODER);
    }
}

