/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.client.impl.clientside.CandidateClusterContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ClientDiscoveryService
implements Iterator<CandidateClusterContext> {
    private final ArrayList<CandidateClusterContext> discoveryServices;
    private final long size;
    private final int configsMaxTryCount;
    private long head;
    private long currentTryCount;

    public ClientDiscoveryService(int configsTryCount, ArrayList<CandidateClusterContext> discoveryServices) {
        this.discoveryServices = discoveryServices;
        this.size = discoveryServices.size();
        this.configsMaxTryCount = configsTryCount;
    }

    public void resetSearch() {
        this.currentTryCount = 0L;
    }

    @Override
    public boolean hasNext() {
        return this.currentTryCount != (long)this.configsMaxTryCount;
    }

    public CandidateClusterContext current() {
        return this.discoveryServices.get((int)(this.head % this.size));
    }

    @Override
    public CandidateClusterContext next() {
        if (this.currentTryCount == (long)this.configsMaxTryCount) {
            throw new NoSuchElementException("Has no alternative cluster");
        }
        CandidateClusterContext candidateClusterContext = this.discoveryServices.get((int)(this.head % this.size));
        ++this.head;
        if (this.head % this.size == 0L) {
            ++this.currentTryCount;
        }
        return candidateClusterContext;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }

    public void shutdown() {
        for (CandidateClusterContext discoveryService : this.discoveryServices) {
            discoveryService.getCredentialsFactory().destroy();
        }
    }
}

