/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConfigSections;
import com.hazelcast.client.config.ClientDomConfigProcessor;
import com.hazelcast.client.config.XmlClientConfigLocator;
import com.hazelcast.config.AbstractXmlConfigBuilder;
import com.hazelcast.config.ConfigLoader;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.IOUtil;
import com.hazelcast.util.ExceptionUtil;
import com.hazelcast.util.StringUtil;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlClientConfigBuilder
extends AbstractXmlConfigBuilder {
    private static final ILogger LOGGER = Logger.getLogger(XmlClientConfigBuilder.class);
    private final InputStream in;

    public XmlClientConfigBuilder(String resource) throws IOException {
        URL url = ConfigLoader.locateConfig((String)resource);
        if (url == null) {
            throw new IllegalArgumentException("Could not load " + resource);
        }
        this.in = url.openStream();
    }

    public XmlClientConfigBuilder(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("File is null!");
        }
        this.in = new FileInputStream(file);
    }

    public XmlClientConfigBuilder(URL url) throws IOException {
        if (url == null) {
            throw new NullPointerException("URL is null!");
        }
        this.in = url.openStream();
    }

    public XmlClientConfigBuilder(InputStream in) {
        this.in = in;
    }

    public XmlClientConfigBuilder() {
        this((XmlClientConfigLocator)null);
    }

    public XmlClientConfigBuilder(XmlClientConfigLocator locator) {
        if (locator == null) {
            locator = new XmlClientConfigLocator();
            locator.locateEverywhere();
        }
        this.in = locator.getIn();
    }

    protected Document parse(InputStream inputStream) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        try {
            Document document = builder.parse(inputStream);
            return document;
        }
        catch (Exception e) {
            String msg = "Failed to parse Config Stream" + StringUtil.LINE_SEPARATOR + "Exception: " + e.getMessage() + StringUtil.LINE_SEPARATOR + "HazelcastClient startup interrupted.";
            LOGGER.severe(msg);
            throw new InvalidConfigurationException(e.getMessage(), (Throwable)e);
        }
        finally {
            IOUtil.closeResource((Closeable)inputStream);
        }
    }

    public XmlClientConfigBuilder setProperties(Properties properties) {
        this.setPropertiesInternal(properties);
        return this;
    }

    protected AbstractXmlConfigBuilder.ConfigType getConfigType() {
        return AbstractXmlConfigBuilder.ConfigType.CLIENT;
    }

    public ClientConfig build() {
        return this.build(Thread.currentThread().getContextClassLoader());
    }

    public ClientConfig build(ClassLoader classLoader) {
        ClientConfig clientConfig = new ClientConfig();
        this.build(clientConfig, classLoader);
        return clientConfig;
    }

    void build(ClientConfig clientConfig, ClassLoader classLoader) {
        clientConfig.setClassLoader(classLoader);
        try {
            this.parseAndBuildConfig(clientConfig);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e);
        }
        finally {
            IOUtil.closeResource((Closeable)this.in);
        }
    }

    private void parseAndBuildConfig(ClientConfig clientConfig) throws Exception {
        Document doc = this.parse(this.in);
        Element root = doc.getDocumentElement();
        this.checkRootElement(root);
        try {
            root.getTextContent();
        }
        catch (Throwable e) {
            this.domLevel3 = false;
        }
        this.process(root);
        this.schemaValidation(root.getOwnerDocument());
        new ClientDomConfigProcessor(this.domLevel3, clientConfig).buildConfig(root);
    }

    private void checkRootElement(Element root) {
        String rootNodeName = root.getNodeName();
        if (!ClientConfigSections.HAZELCAST_CLIENT.isEqual(rootNodeName)) {
            throw new InvalidConfigurationException("Invalid root element in xml configuration! Expected: <" + ClientConfigSections.HAZELCAST_CLIENT.name + ">, Actual: <" + rootNodeName + ">.");
        }
    }
}

