/*
 * Decompiled with CFR 0.152.
 */
package classloading;

import classloading.ThreadLeakTestUtils;
import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientUserCodeDeploymentConfig;
import com.hazelcast.client.spi.impl.discovery.ClientDiscoverySpiTest;
import com.hazelcast.config.DiscoveryStrategyConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.spi.discovery.DiscoveryStrategyFactory;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collections;
import java.util.Set;
import org.junit.After;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class ThreadLeakClientTest {
    @After
    public void shutdownInstances() {
        HazelcastClient.shutdownAll();
        Hazelcast.shutdownAll();
    }

    @Test
    public void testThreadLeak() {
        Set testStartThreads = ThreadLeakTestUtils.getThreads();
        HazelcastInstance member = Hazelcast.newHazelcastInstance();
        HazelcastInstance client = HazelcastClient.newHazelcastClient();
        client.shutdown();
        member.shutdown();
        ThreadLeakTestUtils.assertHazelcastThreadShutdown((Set)testStartThreads);
    }

    @Test
    public void testThreadLeak_withoutCluster() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getConnectionStrategyConfig().setAsyncStart(true);
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        Set testStartThreads = ThreadLeakTestUtils.getThreads();
        HazelcastInstance client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        client.shutdown();
        ThreadLeakTestUtils.assertHazelcastThreadShutdown((Set)testStartThreads);
    }

    @Test(expected=IllegalStateException.class)
    public void testThreadLeakWhenClientCanNotStart() {
        Set testStartThreads = ThreadLeakTestUtils.getThreads();
        try {
            HazelcastClient.newHazelcastClient();
        }
        finally {
            ThreadLeakTestUtils.assertHazelcastThreadShutdown((Set)testStartThreads);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testThreadLeakWhenClientCanNotStartDueToAuthenticationError() {
        Hazelcast.newHazelcastInstance();
        ClientConfig config = new ClientConfig();
        config.getGroupConfig().setName("invalid cluster");
        Set testStartThreads = ThreadLeakTestUtils.getThreads();
        try {
            HazelcastClient.newHazelcastClient((ClientConfig)config);
        }
        finally {
            Hazelcast.shutdownAll();
            ThreadLeakTestUtils.assertHazelcastThreadShutdown((Set)testStartThreads);
        }
    }

    @Test(expected=IllegalStateException.class)
    public void testThreadLeakWhenClientCanNotConstructDueToNoMemberDiscoveryStrategyConfig() {
        ClientConfig config = new ClientConfig();
        config.getNetworkConfig().getDiscoveryConfig().addDiscoveryStrategyConfig(new DiscoveryStrategyConfig((DiscoveryStrategyFactory)new ClientDiscoverySpiTest.NoMemberDiscoveryStrategyFactory(), Collections.emptyMap()));
        Set testStartThreads = ThreadLeakTestUtils.getThreads();
        try {
            HazelcastClient.newHazelcastClient((ClientConfig)config);
        }
        finally {
            ThreadLeakTestUtils.assertHazelcastThreadShutdown((Set)testStartThreads);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=HazelcastException.class)
    public void testThreadLeakWhenClientCanNotStartDueToIncorrectUserCodeDeploymentClass() {
        Hazelcast.newHazelcastInstance();
        ClientConfig config = new ClientConfig();
        ClientUserCodeDeploymentConfig clientUserCodeDeploymentConfig = new ClientUserCodeDeploymentConfig();
        clientUserCodeDeploymentConfig.addClass("invalid.class.test");
        config.setUserCodeDeploymentConfig(clientUserCodeDeploymentConfig.setEnabled(true));
        Set testStartThreads = ThreadLeakTestUtils.getThreads();
        try {
            HazelcastClient.newHazelcastClient((ClientConfig)config);
        }
        finally {
            Hazelcast.shutdownAll();
            ThreadLeakTestUtils.assertHazelcastThreadShutdown((Set)testStartThreads);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=HazelcastSerializationException.class)
    public void testThreadLeakWhenClientCanNotConstructDueToIncorrectSerializationServiceFactoryClassName() {
        ClientConfig config = new ClientConfig();
        SerializationConfig serializationConfig = new SerializationConfig();
        serializationConfig.addDataSerializableFactoryClass(5, "invalid.factory");
        config.setSerializationConfig(serializationConfig);
        Set testStartThreads = ThreadLeakTestUtils.getThreads();
        try {
            HazelcastClient.newHazelcastClient((ClientConfig)config);
        }
        finally {
            ThreadLeakTestUtils.assertHazelcastThreadShutdown((Set)testStartThreads);
        }
    }
}

