/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientAuthenticationTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private final String USERNAME = "user";
    private final String PASSWORD = "pass";

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test(expected=IllegalStateException.class)
    public void testNoClusterFound() throws Exception {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionAttemptPeriod(1);
        this.hazelcastFactory.newHazelcastClient(clientConfig);
    }

    @Test
    public void testAuthenticationWithCustomCredentials_when_singleNode() {
        CustomCredentialsPortableFactory factory = new CustomCredentialsPortableFactory();
        Config config = new Config();
        config.getGroupConfig().setName("user").setPassword("pass");
        config.getSerializationConfig().addPortableFactory(1, (PortableFactory)factory);
        this.hazelcastFactory.newHazelcastInstance(config);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getSecurityConfig().setCredentials((Credentials)new CustomCredentials());
        this.hazelcastFactory.newHazelcastClient(clientConfig);
    }

    @Test
    public void testAuthenticationWithCustomCredentials_when_multipleNodes() {
        CustomCredentialsPortableFactory factory = new CustomCredentialsPortableFactory();
        Config config = new Config();
        config.getGroupConfig().setName("user").setPassword("pass");
        config.getSerializationConfig().addPortableFactory(1, (PortableFactory)factory);
        this.hazelcastFactory.newHazelcastInstance(config);
        this.hazelcastFactory.newHazelcastInstance(config);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getSecurityConfig().setCredentials((Credentials)new CustomCredentials());
        HazelcastInstance hazelcastInstance = this.hazelcastFactory.newHazelcastClient(clientConfig);
        IMap map = hazelcastInstance.getMap(ClientAuthenticationTest.randomName());
        for (int i = 0; i < 100; ++i) {
            map.put((Object)i, (Object)i);
        }
    }

    private class CustomCredentials
    extends UsernamePasswordCredentials {
        private CustomCredentials() {
        }

        public int getFactoryId() {
            return 1;
        }

        public int getClassId() {
            return 1;
        }
    }

    private class CustomCredentialsPortableFactory
    implements PortableFactory {
        private CustomCredentialsPortableFactory() {
        }

        public Portable create(int classId) {
            return new CustomCredentials(){

                public String getUsername() {
                    return "user";
                }

                public String getPassword() {
                    return "pass";
                }
            };
        }
    }
}

