/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberAttributeEvent;
import com.hazelcast.core.MembershipEvent;
import com.hazelcast.core.MembershipListener;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientClusterRestartEventTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @Before
    public void setUp() {
    }

    @After
    public void tearDown() {
        this.hazelcastFactory.shutdownAll();
    }

    protected Config newConfig() {
        return new Config();
    }

    private ClientConfig newClientConfig() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        return clientConfig;
    }

    @Test
    public void testSingleMemberRestart() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        Member oldMember = instance.getCluster().getLocalMember();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        final CountDownLatch memberAdded = new CountDownLatch(1);
        final CountDownLatch memberRemoved = new CountDownLatch(1);
        final AtomicReference addedMemberReference = new AtomicReference();
        final AtomicReference removedMemberReference = new AtomicReference();
        client.getCluster().addMembershipListener(new MembershipListener(){

            public void memberAdded(MembershipEvent membershipEvent) {
                addedMemberReference.set(membershipEvent.getMember());
                memberAdded.countDown();
            }

            public void memberRemoved(MembershipEvent membershipEvent) {
                removedMemberReference.set(membershipEvent.getMember());
                memberRemoved.countDown();
            }

            public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
            }
        });
        instance.shutdown();
        instance = this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        Member newMember = instance.getCluster().getLocalMember();
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)memberRemoved);
        Assert.assertEquals((Object)oldMember, removedMemberReference.get());
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)memberAdded);
        Assert.assertEquals((Object)newMember, addedMemberReference.get());
        Set members = client.getCluster().getMembers();
        HazelcastTestSupport.assertContains((Collection)members, (Object)newMember);
        Assert.assertEquals((long)1L, (long)members.size());
    }

    @Test
    public void testMultiMemberRestart() throws ExecutionException, InterruptedException {
        HazelcastInstance instance1 = this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        HazelcastInstance instance2 = this.hazelcastFactory.newHazelcastInstance(this.newConfig());
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(this.newClientConfig());
        Member oldMember1 = instance1.getCluster().getLocalMember();
        Member oldMember2 = instance2.getCluster().getLocalMember();
        final CountDownLatch memberAdded = new CountDownLatch(2);
        final Set addedMembers = Collections.newSetFromMap(new ConcurrentHashMap());
        final CountDownLatch memberRemoved = new CountDownLatch(2);
        final Set removedMembers = Collections.newSetFromMap(new ConcurrentHashMap());
        client.getCluster().addMembershipListener(new MembershipListener(){

            public void memberAdded(MembershipEvent membershipEvent) {
                addedMembers.add(membershipEvent.getMember());
                memberAdded.countDown();
            }

            public void memberRemoved(MembershipEvent membershipEvent) {
                removedMembers.add(membershipEvent.getMember());
                memberRemoved.countDown();
            }

            public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
            }
        });
        instance1.getCluster().shutdown();
        Future f1 = HazelcastTestSupport.spawn((Callable)new Callable<HazelcastInstance>(){

            @Override
            public HazelcastInstance call() {
                return ClientClusterRestartEventTest.this.hazelcastFactory.newHazelcastInstance(ClientClusterRestartEventTest.this.newConfig());
            }
        });
        Future f2 = HazelcastTestSupport.spawn((Callable)new Callable<HazelcastInstance>(){

            @Override
            public HazelcastInstance call() {
                return ClientClusterRestartEventTest.this.hazelcastFactory.newHazelcastInstance(ClientClusterRestartEventTest.this.newConfig());
            }
        });
        instance1 = (HazelcastInstance)f1.get();
        instance2 = (HazelcastInstance)f2.get();
        Member newMember1 = instance1.getCluster().getLocalMember();
        Member newMember2 = instance2.getCluster().getLocalMember();
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)memberRemoved);
        Assert.assertEquals((long)2L, (long)removedMembers.size());
        HazelcastTestSupport.assertContains(removedMembers, (Object)oldMember1);
        HazelcastTestSupport.assertContains(removedMembers, (Object)oldMember2);
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)memberAdded);
        Assert.assertEquals((long)2L, (long)addedMembers.size());
        HazelcastTestSupport.assertContains(addedMembers, (Object)newMember1);
        HazelcastTestSupport.assertContains(addedMembers, (Object)newMember2);
        Set members = client.getCluster().getMembers();
        HazelcastTestSupport.assertContains((Collection)members, (Object)newMember1);
        HazelcastTestSupport.assertContains((Collection)members, (Object)newMember2);
        Assert.assertEquals((long)2L, (long)members.size());
    }
}

