/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.impl.clientside.ClientTestUtil;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.Client;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.Member;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionListener;
import com.hazelcast.security.Credentials;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientConnectionTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test(expected=IllegalStateException.class)
    public void testWithIllegalAddress() {
        String illegalAddress = ClientConnectionTest.randomString();
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig config = new ClientConfig();
        config.getNetworkConfig().setConnectionAttemptPeriod(1);
        config.getNetworkConfig().addAddress(new String[]{illegalAddress});
        this.hazelcastFactory.newHazelcastClient(config);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEmptyStringAsAddress() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().addAddress(new String[]{""});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullAsAddress() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().addAddress(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNullAsAddresses() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().addAddress(new String[]{null, null});
    }

    @Test
    public void testWithLegalAndIllegalAddressTogether() {
        String illegalAddress = ClientConnectionTest.randomString();
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance();
        Address serverAddress = server.getCluster().getLocalMember().getAddress();
        ClientConfig config = new ClientConfig();
        config.setProperty(ClientProperty.SHUFFLE_MEMBER_LIST.getName(), "false");
        config.getNetworkConfig().addAddress(new String[]{illegalAddress}).addAddress(new String[]{serverAddress.getHost() + ":" + serverAddress.getPort()});
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(config);
        Collection connectedClients = server.getClientService().getConnectedClients();
        Assert.assertEquals((long)connectedClients.size(), (long)1L);
        Client serverSideClientInfo = (Client)connectedClients.iterator().next();
        Assert.assertEquals((Object)serverSideClientInfo.getUuid(), (Object)client.getLocalEndpoint().getUuid());
    }

    @Test
    public void testMemberConnectionOrder() {
        HazelcastInstance server1 = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance server2 = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig config = new ClientConfig();
        config.setProperty(ClientProperty.SHUFFLE_MEMBER_LIST.getName(), "false");
        config.getNetworkConfig().setSmartRouting(false);
        Address address1 = server1.getCluster().getLocalMember().getAddress();
        Address address2 = server2.getCluster().getLocalMember().getAddress();
        config.getNetworkConfig().addAddress(new String[]{address1.getHost() + ":" + address1.getPort()}).addAddress(new String[]{address2.getHost() + ":" + address2.getPort()});
        this.hazelcastFactory.newHazelcastClient(config);
        Collection connectedClients1 = server1.getClientService().getConnectedClients();
        Assert.assertEquals((long)connectedClients1.size(), (long)1L);
        Collection connectedClients2 = server2.getClientService().getConnectedClients();
        Assert.assertEquals((long)connectedClients2.size(), (long)0L);
    }

    @Test
    public void destroyConnection_whenDestroyedMultipleTimes_thenListenerRemoveCalledOnce() {
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        HazelcastClientInstanceImpl clientImpl = ClientTestUtil.getHazelcastClientInstanceImpl(client);
        ClientConnectionManager connectionManager = clientImpl.getConnectionManager();
        CountingConnectionListener listener = new CountingConnectionListener();
        connectionManager.addConnectionListener((ConnectionListener)listener);
        Address serverAddress = server.getCluster().getLocalMember().getAddress();
        Connection connectionToServer = connectionManager.getActiveConnection(serverAddress);
        final CountDownLatch isConnected = new CountDownLatch(1);
        clientImpl.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (LifecycleEvent.LifecycleState.CLIENT_CONNECTED == event.getState()) {
                    isConnected.countDown();
                }
            }
        });
        connectionToServer.close(null, null);
        ClientConnectionTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertTrue((boolean)isConnected.await(5L, TimeUnit.SECONDS));
            }
        });
        connectionToServer.close(null, null);
        Assert.assertEquals((String)"connection removed should be called only once", (long)1L, (long)listener.connectionRemovedCount.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAsyncConnectionCreationInAsyncMethods() throws ExecutionException, InterruptedException {
        this.hazelcastFactory.newHazelcastInstance();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        ClientConfig config = new ClientConfig();
        WaitingCredentials credentials = new WaitingCredentials("dev", "dev-pass", countDownLatch);
        config.setCredentials((Credentials)credentials);
        final HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(config);
        final IExecutorService executorService = client.getExecutorService(ClientConnectionTest.randomString());
        credentials.waitFlag.set(true);
        final HazelcastInstance secondInstance = this.hazelcastFactory.newHazelcastInstance();
        ClientConnectionTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)2L, (long)client.getCluster().getMembers().size());
            }
        });
        final AtomicReference atomicReference = new AtomicReference();
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Member secondMember = secondInstance.getCluster().getLocalMember();
                Future future = executorService.submitToMember((Callable)new HazelcastTestSupport.DummySerializableCallable(), secondMember);
                atomicReference.set(future);
            }
        });
        thread.start();
        try {
            ClientConnectionTest.assertTrueEventually((AssertTask)new AssertTask(){

                public void run() throws Exception {
                    Assert.assertNotNull(atomicReference.get());
                }
            }, (long)30L);
        }
        finally {
            thread.interrupt();
            thread.join();
            countDownLatch.countDown();
        }
    }

    @Test
    public void testAddingConnectionListenerTwice_shouldCauseEventDeliveredTwice() {
        this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        HazelcastClientInstanceImpl clientImpl = ClientTestUtil.getHazelcastClientInstanceImpl(client);
        ClientConnectionManager connectionManager = clientImpl.getConnectionManager();
        final CountingConnectionListener listener = new CountingConnectionListener();
        connectionManager.addConnectionListener((ConnectionListener)listener);
        connectionManager.addConnectionListener((ConnectionListener)listener);
        this.hazelcastFactory.newHazelcastInstance();
        ClientConnectionTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)listener.connectionAddedCount.get(), (long)2L);
            }
        });
    }

    static class WaitingCredentials
    extends UsernamePasswordCredentials {
        private final CountDownLatch countDownLatch;
        AtomicBoolean waitFlag = new AtomicBoolean();

        WaitingCredentials(String username, String password, CountDownLatch countDownLatch) {
            super(username, password);
            this.countDownLatch = countDownLatch;
        }

        public String getUsername() {
            return super.getUsername();
        }

        public String getPassword() {
            if (this.waitFlag.get()) {
                try {
                    this.countDownLatch.await();
                }
                catch (InterruptedException e) {
                    HazelcastTestSupport.ignore((Throwable)e);
                }
            }
            return super.getPassword();
        }
    }

    private class CountingConnectionListener
    implements ConnectionListener {
        final AtomicInteger connectionRemovedCount = new AtomicInteger();
        final AtomicInteger connectionAddedCount = new AtomicInteger();

        private CountingConnectionListener() {
        }

        public void connectionAdded(Connection connection) {
            this.connectionAddedCount.incrementAndGet();
        }

        public void connectionRemoved(Connection connection) {
            this.connectionRemovedCount.incrementAndGet();
        }
    }
}

