/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.core.Client;
import com.hazelcast.core.ClientListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceNotActiveException;
import com.hazelcast.core.IMap;
import com.hazelcast.core.IQueue;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.operationparker.impl.OperationParkerImpl;
import com.hazelcast.spi.impl.operationservice.impl.InvocationRegistry;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.topic.ReliableMessageListener;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientDisconnectTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testClientOperationCancelled_whenDisconnected() throws Exception {
        Config config = new Config();
        config.setProperty(GroupProperty.CLIENT_ENDPOINT_REMOVE_DELAY_SECONDS.getName(), String.valueOf(Integer.MAX_VALUE));
        HazelcastInstance hazelcastInstance = this.hazelcastFactory.newHazelcastInstance(config);
        String queueName = "q";
        final HazelcastInstance clientInstance = this.hazelcastFactory.newHazelcastClient();
        final String uuid = clientInstance.getLocalEndpoint().getUuid();
        final CountDownLatch clientDisconnectedFromNode = new CountDownLatch(1);
        hazelcastInstance.getClientService().addClientListener(new ClientListener(){

            public void clientConnected(Client client) {
            }

            public void clientDisconnected(Client client) {
                if (client.getUuid().equals(uuid)) {
                    clientDisconnectedFromNode.countDown();
                }
            }
        });
        new Thread(new Runnable(){

            @Override
            public void run() {
                IQueue queue = clientInstance.getQueue("q");
                try {
                    queue.take();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (HazelcastInstanceNotActiveException e) {
                    HazelcastTestSupport.ignore((Throwable)e);
                }
            }
        }).start();
        TimeUnit.SECONDS.sleep(2L);
        clientInstance.shutdown();
        ClientDisconnectTest.assertOpenEventually((CountDownLatch)clientDisconnectedFromNode);
        final IQueue queue = hazelcastInstance.getQueue("q");
        queue.add((Object)1);
        ClientDisconnectTest.assertTrueAllTheTime((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertEquals((long)queue.size(), (long)1L);
            }
        }, (long)3L);
    }

    @Test
    public void testClientOperationCancelled_whenDisconnected_lock() throws Exception {
        Config config = new Config();
        config.setProperty(GroupProperty.CLIENT_ENDPOINT_REMOVE_DELAY_SECONDS.getName(), String.valueOf(Integer.MAX_VALUE));
        HazelcastInstance hazelcastInstance = this.hazelcastFactory.newHazelcastInstance(config);
        String name = "m";
        final IMap map = hazelcastInstance.getMap("m");
        String key = "key";
        map.lock((Object)"key");
        final HazelcastInstance clientInstance = this.hazelcastFactory.newHazelcastClient();
        final CountDownLatch clientDisconnectedFromNode = new CountDownLatch(1);
        final String uuid = clientInstance.getLocalEndpoint().getUuid();
        hazelcastInstance.getClientService().addClientListener(new ClientListener(){

            public void clientConnected(Client client) {
            }

            public void clientDisconnected(Client client) {
                if (client.getUuid().equals(uuid)) {
                    clientDisconnectedFromNode.countDown();
                }
            }
        });
        new Thread(new Runnable(){

            @Override
            public void run() {
                IMap clientMap = clientInstance.getMap("m");
                try {
                    clientMap.lock((Object)"key");
                }
                catch (Exception e) {
                    HazelcastTestSupport.ignore((Throwable)e);
                }
            }
        }).start();
        TimeUnit.SECONDS.sleep(2L);
        clientInstance.shutdown();
        ClientDisconnectTest.assertOpenEventually((CountDownLatch)clientDisconnectedFromNode);
        map.unlock((Object)"key");
        ClientDisconnectTest.assertTrueAllTheTime((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertFalse((boolean)map.isLocked((Object)"key"));
            }
        }, (long)3L);
    }

    @Test
    public void testPendingInvocationAndWaitEntryCancelled_whenDisconnected_withLock() {
        Config config = new Config();
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance(config);
        final String name = ClientDisconnectTest.randomName();
        server.getLock(name).lock();
        final HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        ClientDisconnectTest.spawn((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    client.getLock(name).lock();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        });
        this.assertNonEmptyPendingInvocationAndWaitSet(server);
        client.shutdown();
        this.assertEmptyPendingInvocationAndWaitSet(server);
    }

    @Test
    public void testPendingInvocationAndWaitEntryCancelled_whenDisconnected_withReliableTopic() {
        Config config = new Config();
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance(config);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        client.getReliableTopic(ClientDisconnectTest.randomName()).addMessageListener((MessageListener)new NopReliableMessageListener());
        this.assertNonEmptyPendingInvocationAndWaitSet(server);
        client.shutdown();
        this.assertEmptyPendingInvocationAndWaitSet(server);
    }

    private void assertNonEmptyPendingInvocationAndWaitSet(HazelcastInstance server) {
        NodeEngineImpl nodeEngine = ClientDisconnectTest.getNodeEngineImpl((HazelcastInstance)server);
        OperationServiceImpl operationService = (OperationServiceImpl)nodeEngine.getOperationService();
        final InvocationRegistry invocationRegistry = operationService.getInvocationRegistry();
        final OperationParkerImpl operationParker = (OperationParkerImpl)nodeEngine.getOperationParker();
        ClientDisconnectTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertFalse((boolean)invocationRegistry.entrySet().isEmpty());
            }
        });
        ClientDisconnectTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertTrue((operationParker.getTotalParkedOperationCount() > 0 ? 1 : 0) != 0);
            }
        });
    }

    private void assertEmptyPendingInvocationAndWaitSet(HazelcastInstance server) {
        NodeEngineImpl nodeEngine = ClientDisconnectTest.getNodeEngineImpl((HazelcastInstance)server);
        OperationServiceImpl operationService = (OperationServiceImpl)nodeEngine.getOperationService();
        final InvocationRegistry invocationRegistry = operationService.getInvocationRegistry();
        final OperationParkerImpl operationParker = (OperationParkerImpl)nodeEngine.getOperationParker();
        ClientDisconnectTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertTrue((boolean)invocationRegistry.entrySet().isEmpty());
            }
        });
        ClientDisconnectTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() {
                Assert.assertEquals((long)0L, (long)operationParker.getTotalParkedOperationCount());
            }
        });
    }

    private static class NopReliableMessageListener
    implements ReliableMessageListener<Object> {
        private NopReliableMessageListener() {
        }

        public long retrieveInitialSequence() {
            return 0L;
        }

        public void storeSequence(long sequence) {
        }

        public boolean isLossTolerant() {
            return false;
        }

        public boolean isTerminal(Throwable failure) {
            return false;
        }

        public void onMessage(Message<Object> message) {
        }
    }
}

