/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.Client;
import com.hazelcast.core.ClientListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import junit.framework.TestCase;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientLabelTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private final String label = "attributeValue";
    private final String nonExistingLabel = "nonExistingLabel";

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void test_clientLabel_overClientConfig() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.addLabel("attributeValue");
        TestCase.assertTrue((boolean)clientConfig.getLabels().contains("attributeValue"));
        Assert.assertEquals((long)1L, (long)clientConfig.getLabels().size());
        Assert.assertFalse((boolean)clientConfig.getLabels().contains("nonExistingLabel"));
    }

    @Test
    public void test_clientLabel_overGetConnectedClients() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.addLabel("attributeValue");
        this.hazelcastFactory.newHazelcastClient(clientConfig);
        Collection connectedClients = instance.getClientService().getConnectedClients();
        Client client = (Client)connectedClients.iterator().next();
        Assert.assertEquals((long)1L, (long)client.getLabels().size());
        HazelcastTestSupport.assertContains((Collection)client.getLabels(), (Object)"attributeValue");
        HazelcastTestSupport.assertNotContains((Collection)client.getLabels(), (Object)"nonExistingLabel");
    }

    @Test
    public void test_clientAttribute_overClientConnectedEvent() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        final CountDownLatch clientConnected = new CountDownLatch(1);
        final AtomicReference clientRef = new AtomicReference();
        instance.getClientService().addClientListener(new ClientListener(){

            public void clientConnected(Client client) {
                clientRef.set(client);
                clientConnected.countDown();
            }

            public void clientDisconnected(Client client) {
            }
        });
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.addLabel("attributeValue");
        this.hazelcastFactory.newHazelcastClient(clientConfig);
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)clientConnected);
        Client client = (Client)clientRef.get();
        Assert.assertEquals((long)1L, (long)client.getLabels().size());
        HazelcastTestSupport.assertContains((Collection)client.getLabels(), (Object)"attributeValue");
        HazelcastTestSupport.assertNotContains((Collection)client.getLabels(), (Object)"nonExistingLabel");
    }

    @Test
    public void test_clientAttribute_overClientDisconnectedEvent() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        final CountDownLatch clientDisconnected = new CountDownLatch(1);
        final AtomicReference clientRef = new AtomicReference();
        instance.getClientService().addClientListener(new ClientListener(){

            public void clientConnected(Client client) {
            }

            public void clientDisconnected(Client client) {
                clientRef.set(client);
                clientDisconnected.countDown();
            }
        });
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.addLabel("attributeValue");
        HazelcastInstance clientInstance = this.hazelcastFactory.newHazelcastClient(clientConfig);
        clientInstance.shutdown();
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)clientDisconnected);
        Client client = (Client)clientRef.get();
        Assert.assertEquals((long)1L, (long)client.getLabels().size());
        HazelcastTestSupport.assertContains((Collection)client.getLabels(), (Object)"attributeValue");
        HazelcastTestSupport.assertNotContains((Collection)client.getLabels(), (Object)"nonExistingLabel");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void test_modifyClientLabels_overGetConnectedClients() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.addLabel("attributeValue");
        this.hazelcastFactory.newHazelcastClient(clientConfig);
        Collection connectedClients = instance.getClientService().getConnectedClients();
        Client client = (Client)connectedClients.iterator().next();
        client.getLabels().add("attributeValue");
    }
}

