/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.Client;
import com.hazelcast.core.ClientListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientNameTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void test_clientName_overClientInstance() {
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        String name = "aClient";
        clientConfig.setInstanceName(name);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        Assert.assertEquals((Object)name, (Object)client.getName());
    }

    @Test
    public void test_clientName_overGetConnectedClients() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        String name = "aClient";
        clientConfig.setInstanceName(name);
        this.hazelcastFactory.newHazelcastClient(clientConfig);
        Collection connectedClients = instance.getClientService().getConnectedClients();
        Client client = (Client)connectedClients.iterator().next();
        Assert.assertEquals((Object)name, (Object)client.getName());
    }

    @Test
    public void test_clientName_overClientConnectedEvent() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        final CountDownLatch clientConnected = new CountDownLatch(1);
        final AtomicReference clientName = new AtomicReference();
        instance.getClientService().addClientListener(new ClientListener(){

            public void clientConnected(Client client) {
                clientName.set(client.getName());
                clientConnected.countDown();
            }

            public void clientDisconnected(Client client) {
            }
        });
        ClientConfig clientConfig = new ClientConfig();
        String name = "aClient";
        clientConfig.setInstanceName(name);
        this.hazelcastFactory.newHazelcastClient(clientConfig);
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)clientConnected);
        Assert.assertEquals((Object)name, clientName.get());
    }

    @Test
    public void test_clientName_overClientDisconnectedEvent() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        final CountDownLatch clientDisconnected = new CountDownLatch(1);
        final AtomicReference clientName = new AtomicReference();
        instance.getClientService().addClientListener(new ClientListener(){

            public void clientConnected(Client client) {
            }

            public void clientDisconnected(Client client) {
                clientName.set(client.getName());
                clientDisconnected.countDown();
            }
        });
        ClientConfig clientConfig = new ClientConfig();
        String name = "aClient";
        clientConfig.setInstanceName(name);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        client.shutdown();
        HazelcastTestSupport.assertOpenEventually((CountDownLatch)clientDisconnected);
        Assert.assertEquals((Object)name, clientName.get());
    }
}

