/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.ClientOutOfMemoryHandler;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientOutOfMemoryHandlerTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;
    private HazelcastInstance[] instances;
    private ClientOutOfMemoryHandler outOfMemoryHandler;

    @Before
    public void setUp() {
        this.hazelcastFactory.newHazelcastInstance();
        this.client = this.hazelcastFactory.newHazelcastClient();
        this.instances = new HazelcastInstance[2];
        this.instances[0] = ((HazelcastClientProxy)this.client).client;
        this.instances[1] = null;
        this.outOfMemoryHandler = new ClientOutOfMemoryHandler();
    }

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    @Test
    public void testOnOutOfMemory() {
        this.outOfMemoryHandler.onOutOfMemory(new OutOfMemoryError(), this.instances);
        ClientOutOfMemoryHandlerTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertFalse((String)"The client should be shutdown", (boolean)ClientOutOfMemoryHandlerTest.this.client.getLifecycleService().isRunning());
            }
        });
    }
}

