/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientSecurityConfig;
import com.hazelcast.client.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.ListenerConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.EntryAdapter;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.core.ITopic;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.Message;
import com.hazelcast.core.MessageListener;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.MapInterceptor;
import com.hazelcast.map.listener.MapListener;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.test.AssertTask;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.NightlyTest;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import com.hazelcast.test.annotation.SlowTest;
import java.io.IOException;
import java.util.Collection;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientRegressionWithMockNetworkTest
extends HazelcastTestSupport {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();

    @After
    public void cleanup() {
        this.hazelcastFactory.terminateAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testIssue493() {
        HazelcastInstance hz1 = this.hazelcastFactory.newHazelcastInstance();
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setRedoOperation(true);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        ILock lock = client.getLock("lock");
        for (int k = 0; k < 10; ++k) {
            lock.lock();
            try {
                ClientRegressionWithMockNetworkTest.sleepMillis((int)100);
                continue;
            }
            finally {
                lock.unlock();
            }
        }
        lock.lock();
        hz1.shutdown();
        lock.unlock();
    }

    @Test
    public void testOperationRedo() {
        final HazelcastInstance hz1 = this.hazelcastFactory.newHazelcastInstance();
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setRedoOperation(true);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                hz1.getLifecycleService().shutdown();
            }
        };
        IMap map = client.getMap("m");
        thread.start();
        int expected = 1000;
        for (int i = 0; i < expected; ++i) {
            map.put((Object)i, (Object)("item" + i));
        }
        ClientRegressionWithMockNetworkTest.assertJoinable((Thread[])new Thread[]{thread});
        Assert.assertEquals((long)expected, (long)map.size());
    }

    @Test
    public void testOperationRedo_smartRoutingDisabled() {
        final HazelcastInstance hz1 = this.hazelcastFactory.newHazelcastInstance();
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setRedoOperation(true);
        clientConfig.setSmartRouting(false);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                hz1.getLifecycleService().shutdown();
            }
        };
        IMap map = client.getMap("m");
        thread.start();
        int expected = 1000;
        for (int i = 0; i < expected; ++i) {
            map.put((Object)i, (Object)i);
        }
        ClientRegressionWithMockNetworkTest.assertJoinable((Thread[])new Thread[]{thread});
        Assert.assertEquals((long)expected, (long)map.size());
    }

    @Test
    public void testGetDistributedObjectsIssue678() {
        HazelcastInstance hz = this.hazelcastFactory.newHazelcastInstance();
        hz.getQueue("queue");
        hz.getMap("map");
        hz.getSemaphore("s");
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastClient();
        Collection distributedObjects = instance.getDistributedObjects();
        Assert.assertEquals((long)3L, (long)distributedObjects.size());
    }

    @Test
    public void testMapDestroyIssue764() {
        HazelcastInstance server = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        this.assertNoOfDistributedObject("Initially the server should have %d distributed objects, but had %d", 0, server.getDistributedObjects());
        this.assertNoOfDistributedObject("Initially the client should have %d distributed objects, but had %d", 0, client.getDistributedObjects());
        IMap map = client.getMap("mapToDestroy");
        this.assertNoOfDistributedObject("After getMap() the server should have %d distributed objects, but had %d", 1, server.getDistributedObjects());
        this.assertNoOfDistributedObject("After getMap() the client should have %d distributed objects, but had %d", 1, client.getDistributedObjects());
        map.destroy();
        Collection serverDistributedObjects = server.getDistributedObjects();
        Collection clientDistributedObjects = client.getDistributedObjects();
        this.assertNoOfDistributedObject("After destroy() the server should should have %d distributed objects, but had %d", 0, serverDistributedObjects);
        this.assertNoOfDistributedObject("After destroy() the client should should have %d distributed objects, but had %d", 0, clientDistributedObjects);
    }

    private void assertNoOfDistributedObject(String message, int expected, Collection<DistributedObject> distributedObjects) {
        StringBuilder sb = new StringBuilder(message + "\n");
        for (DistributedObject distributedObject : distributedObjects) {
            sb.append("Name: ").append(distributedObject.getName()).append(", Service: ").append(distributedObject.getServiceName()).append(", PartitionKey: ").append(distributedObject.getPartitionKey()).append("\n");
        }
        ClientRegressionWithMockNetworkTest.assertEqualsStringFormat((String)sb.toString(), (Object)expected, (Object)distributedObjects.size());
    }

    @Test
    public void testIssue821() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        IMap map = client.getMap("default");
        map.put((Object)"key1", (Object)"value1");
        instance.shutdown();
        try {
            map.get((Object)"key1");
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertFalse((boolean)instance.getLifecycleService().isRunning());
    }

    @Test
    public void testClientConnectionEvents() {
        final LinkedList<LifecycleEvent.LifecycleState> list = new LinkedList<LifecycleEvent.LifecycleState>();
        list.offer(LifecycleEvent.LifecycleState.STARTING);
        list.offer(LifecycleEvent.LifecycleState.STARTED);
        list.offer(LifecycleEvent.LifecycleState.CLIENT_CONNECTED);
        list.offer(LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED);
        list.offer(LifecycleEvent.LifecycleState.CLIENT_CONNECTED);
        list.offer(LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED);
        list.offer(LifecycleEvent.LifecycleState.SHUTTING_DOWN);
        list.offer(LifecycleEvent.LifecycleState.SHUTDOWN);
        this.hazelcastFactory.newHazelcastInstance();
        final CountDownLatch latch = new CountDownLatch(list.size());
        final CountDownLatch connectedLatch = new CountDownLatch(2);
        final CountDownLatch disconnectedLatch = new CountDownLatch(2);
        LifecycleListener listener = new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                Logger.getLogger(this.getClass()).info("stateChanged: " + event);
                LifecycleEvent.LifecycleState state = (LifecycleEvent.LifecycleState)list.poll();
                LifecycleEvent.LifecycleState eventState = event.getState();
                if (state != null && state.equals((Object)eventState)) {
                    latch.countDown();
                }
                if (LifecycleEvent.LifecycleState.CLIENT_CONNECTED.equals((Object)eventState)) {
                    connectedLatch.countDown();
                }
                if (LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED.equals((Object)eventState)) {
                    disconnectedLatch.countDown();
                }
            }
        };
        ListenerConfig listenerConfig = new ListenerConfig((EventListener)listener);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.addListenerConfig(listenerConfig);
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(100);
        HazelcastInstance hazelcastClient = this.hazelcastFactory.newHazelcastClient(clientConfig);
        this.hazelcastFactory.shutdownAllMembers();
        this.hazelcastFactory.newHazelcastInstance();
        ClientRegressionWithMockNetworkTest.assertOpenEventually((String)"LifecycleState failed. Expected two CLIENT_CONNECTED events!", (CountDownLatch)connectedLatch);
        this.hazelcastFactory.shutdownAllMembers();
        ClientRegressionWithMockNetworkTest.assertOpenEventually((String)"LifecycleState failed. Expected two CLIENT_DISCONNECTED events!", (CountDownLatch)disconnectedLatch);
        hazelcastClient.shutdown();
        ClientRegressionWithMockNetworkTest.assertOpenEventually((String)"LifecycleState failed", (CountDownLatch)latch);
    }

    @Test
    public void testInterceptor() {
        this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        IMap map = client.getMap("map");
        MapInterceptorImpl interceptor = new MapInterceptorImpl();
        String id = map.addInterceptor((MapInterceptor)interceptor);
        Assert.assertNotNull((Object)id);
        map.put((Object)"key1", (Object)"value");
        Assert.assertEquals((Object)"value", (Object)map.get((Object)"key1"));
        map.put((Object)"key1", (Object)"value1");
        Assert.assertEquals((Object)"getIntercepted", (Object)map.get((Object)"key1"));
        Assert.assertFalse((boolean)map.replace((Object)"key1", (Object)"getIntercepted", (Object)"val"));
        Assert.assertTrue((boolean)map.replace((Object)"key1", (Object)"value1", (Object)"val"));
        Assert.assertEquals((Object)"val", (Object)map.get((Object)"key1"));
        map.put((Object)"key2", (Object)"oldValue");
        Assert.assertEquals((Object)"oldValue", (Object)map.get((Object)"key2"));
        map.put((Object)"key2", (Object)"newValue");
        Assert.assertEquals((Object)"putIntercepted", (Object)map.get((Object)"key2"));
        map.put((Object)"key3", (Object)"value2");
        Assert.assertEquals((Object)"value2", (Object)map.get((Object)"key3"));
        Assert.assertEquals((Object)"removeIntercepted", (Object)map.remove((Object)"key3"));
    }

    @Test
    public void testClientPortableWithoutRegisteringToNode() {
        this.hazelcastFactory.newHazelcastInstance();
        SerializationConfig serializationConfig = new SerializationConfig();
        serializationConfig.addPortableFactory(5, new PortableFactory(){

            public Portable create(int classId) {
                return new SamplePortable();
            }
        });
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setSerializationConfig(serializationConfig);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        IMap sampleMap = client.getMap(ClientRegressionWithMockNetworkTest.randomString());
        sampleMap.put((Object)1, (Object)new SamplePortable(666));
        SamplePortable samplePortable = (SamplePortable)sampleMap.get((Object)1);
        Assert.assertEquals((long)666L, (long)samplePortable.a);
    }

    @Test
    public void testCredentials() {
        Config config = new Config();
        config.getGroupConfig().setName("foo").setPassword("bar");
        this.hazelcastFactory.newHazelcastInstance(config);
        ClientConfig clientConfig = new ClientConfig();
        ClientSecurityConfig securityConfig = clientConfig.getSecurityConfig();
        securityConfig.setCredentialsClassname(MyCredentials.class.getName());
        this.hazelcastFactory.newHazelcastClient(clientConfig);
    }

    public void testListenerReconnect() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        final CountDownLatch latch = new CountDownLatch(2);
        final IMap m = client.getMap("m");
        String id = m.addEntryListener((EntryListener)new EntryAdapter(){

            public void entryAdded(EntryEvent event) {
                latch.countDown();
            }

            public void entryUpdated(EntryEvent event) {
                latch.countDown();
            }
        }, true);
        m.put((Object)"key1", (Object)"value1");
        this.hazelcastFactory.newHazelcastInstance();
        instance.shutdown();
        Thread thread = new Thread(){

            @Override
            public void run() {
                while (!this.isInterrupted()) {
                    m.put((Object)"key2", (Object)"value2");
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        };
        thread.start();
        ClientRegressionWithMockNetworkTest.assertOpenEventually((CountDownLatch)latch, (long)10L);
        thread.interrupt();
        ClientRegressionWithMockNetworkTest.assertJoinable((Thread[])new Thread[]{thread});
        Assert.assertTrue((boolean)m.removeEntryListener(id));
        Assert.assertFalse((boolean)m.removeEntryListener("foo"));
    }

    @Test
    public void testNearCache_WhenRegisteredNodeIsDead() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        String mapName = ClientRegressionWithMockNetworkTest.randomMapName();
        NearCacheConfig nearCacheConfig = new NearCacheConfig();
        nearCacheConfig.setName(mapName);
        nearCacheConfig.setInvalidateOnChange(true);
        clientConfig.addNearCacheConfig(nearCacheConfig);
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        final IMap map = client.getMap(mapName);
        map.put((Object)"a", (Object)"b");
        map.get((Object)"a");
        instance.shutdown();
        this.hazelcastFactory.newHazelcastInstance();
        ClientRegressionWithMockNetworkTest.assertTrueEventually((AssertTask)new AssertTask(){

            public void run() throws Exception {
                Assert.assertNull((Object)map.get((Object)"a"));
            }
        });
    }

    @Category(value={NightlyTest.class})
    @Test
    public void testLock_WhenDummyClientAndOwnerNodeDiesTogether() throws Exception {
        this.testLock_WhenClientAndOwnerNodeDiesTogether(false);
    }

    @Category(value={NightlyTest.class})
    @Test
    public void testLock_WhenSmartClientAndOwnerNodeDiesTogether() throws Exception {
        this.testLock_WhenClientAndOwnerNodeDiesTogether(true);
    }

    private void testLock_WhenClientAndOwnerNodeDiesTogether(boolean smart) throws Exception {
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setSmartRouting(smart);
        int tryCount = 5;
        for (int i = 0; i < 5; ++i) {
            HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
            HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
            ILock lock = client.getLock("lock");
            Assert.assertTrue((boolean)lock.tryLock(1L, TimeUnit.MINUTES));
            client.getLifecycleService().terminate();
            instance.getLifecycleService().terminate();
        }
    }

    @Test
    public void testDeadlock_WhenDoingOperationFromListeners() {
        this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(new ClientConfig().setExecutorPoolSize(1));
        int putCount = 1000;
        final CountDownLatch latch = new CountDownLatch(1000);
        IMap map1 = client.getMap(ClientRegressionWithMockNetworkTest.randomMapName());
        final IMap map2 = client.getMap(ClientRegressionWithMockNetworkTest.randomMapName());
        map1.addEntryListener((EntryListener)new EntryAdapter<Object, Object>(){

            public void entryAdded(EntryEvent<Object, Object> event) {
                map2.put((Object)1, (Object)1);
                latch.countDown();
            }
        }, false);
        for (int i = 0; i < 1000; ++i) {
            map1.put((Object)i, (Object)i);
        }
        ClientRegressionWithMockNetworkTest.assertOpenEventually((CountDownLatch)latch);
    }

    @Test
    public void testDeadlock_WhenDoingOperationFromLifecycleListener() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig.setExecutorPoolSize(1));
        this.hazelcastFactory.newHazelcastInstance();
        final CountDownLatch latch = new CountDownLatch(1);
        final IMap map = client.getMap(ClientRegressionWithMockNetworkTest.randomMapName());
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (event.getState() == LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED) {
                    map.get((Object)1);
                    latch.countDown();
                }
            }
        });
        instance.shutdown();
        ClientRegressionWithMockNetworkTest.assertOpenEventually((CountDownLatch)latch);
    }

    @Test
    public void testDeadlock_WhenDoingOperationFromLifecycleListenerWithInitialPartitionTable() {
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig.setExecutorPoolSize(1));
        this.hazelcastFactory.newHazelcastInstance();
        final CountDownLatch latch = new CountDownLatch(1);
        final IMap map = client.getMap(ClientRegressionWithMockNetworkTest.randomMapName());
        map.get((Object)1);
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (event.getState() == LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED) {
                    for (int i = 0; i < 1000; ++i) {
                        map.get((Object)i);
                    }
                    latch.countDown();
                }
            }
        });
        instance.shutdown();
        ClientRegressionWithMockNetworkTest.assertOpenEventually((CountDownLatch)latch);
    }

    @Test
    public void testDeadlock_whenDoingOperationFromLifecycleListener_withNearCache() {
        String mapName = ClientRegressionWithMockNetworkTest.randomMapName();
        EvictionConfig evictionConfig = new EvictionConfig().setMaximumSizePolicy(EvictionConfig.MaxSizePolicy.ENTRY_COUNT).setSize(1);
        NearCacheConfig nearCacheConfig = new NearCacheConfig().setName(mapName).setEvictionConfig(evictionConfig);
        ClientConfig clientConfig = new ClientConfig().addNearCacheConfig(nearCacheConfig).setExecutorPoolSize(1);
        HazelcastInstance instance = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        this.hazelcastFactory.newHazelcastInstance();
        final CountDownLatch latch = new CountDownLatch(1);
        final IMap map = client.getMap(mapName);
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (event.getState() == LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED) {
                    map.get((Object)1);
                    map.get((Object)2);
                    latch.countDown();
                }
            }
        });
        instance.shutdown();
        ClientRegressionWithMockNetworkTest.assertOpenEventually((CountDownLatch)latch);
    }

    @Test(expected=ExecutionException.class, timeout=120000L)
    public void testGithubIssue3557() throws Exception {
        HazelcastInstance hz = this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient();
        UnDeserializable unDeserializable = new UnDeserializable(1);
        IExecutorService executorService = client.getExecutorService("default");
        Issue2509Runnable task = new Issue2509Runnable(unDeserializable);
        Future future = executorService.submitToMember((Callable)task, hz.getCluster().getLocalMember());
        future.get();
    }

    @Test
    public void testNearCache_shutdownClient() {
        ClientConfig clientConfig = new ClientConfig();
        NearCacheConfig invalidateConfig = new NearCacheConfig();
        String mapName = ClientRegressionWithMockNetworkTest.randomMapName();
        invalidateConfig.setName(mapName);
        invalidateConfig.setInvalidateOnChange(true);
        clientConfig.addNearCacheConfig(invalidateConfig);
        this.hazelcastFactory.newHazelcastInstance();
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        IMap map = client.getMap(mapName);
        map.get((Object)1);
        client.shutdown();
    }

    @Test
    public void testClientReconnect_thenCheckRequestsAreRetriedWithoutException() {
        final HazelcastInstance hazelcastInstance = this.hazelcastFactory.newHazelcastInstance();
        final CountDownLatch clientStartedDoingRequests = new CountDownLatch(1);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    clientStartedDoingRequests.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                hazelcastInstance.shutdown();
                ClientRegressionWithMockNetworkTest.this.hazelcastFactory.newHazelcastInstance();
            }
        }).start();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setRedoOperation(true);
        clientConfig.getNetworkConfig().setConnectionAttemptLimit(Integer.MAX_VALUE);
        clientConfig.setProperty(ClientProperty.INVOCATION_TIMEOUT_SECONDS.getName(), String.valueOf(Integer.MAX_VALUE));
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        IMap map = client.getMap(ClientRegressionWithMockNetworkTest.randomMapName());
        int mapSize = 1000;
        for (int i = 0; i < mapSize; ++i) {
            if (i == mapSize / 4) {
                clientStartedDoingRequests.countDown();
            }
            try {
                map.put((Object)i, (Object)i);
                continue;
            }
            catch (Exception e) {
                Assert.assertTrue((String)("Requests should not throw exception with this configuration. Last put key: " + i), (boolean)false);
            }
        }
    }

    @Test
    public void testClusterShutdown_thenCheckOperationsNotHanging() throws Exception {
        HazelcastInstance hazelcastInstance = this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setRedoOperation(true);
        clientConfig.setProperty(ClientProperty.INVOCATION_TIMEOUT_SECONDS.getName(), String.valueOf(Integer.MAX_VALUE));
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        final IMap map = client.getMap(ClientRegressionWithMockNetworkTest.randomMapName());
        int mapSize = 1000;
        final CountDownLatch clientStartedDoingRequests = new CountDownLatch(1);
        int threadCount = 100;
        final CountDownLatch testFinishedLatch = new CountDownLatch(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (int i = 0; i < 1000; ++i) {
                            if (i == 250) {
                                clientStartedDoingRequests.countDown();
                            }
                            map.put((Object)i, (Object)i);
                        }
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        testFinishedLatch.countDown();
                    }
                }
            });
            thread.start();
        }
        Assert.assertTrue((boolean)clientStartedDoingRequests.await(30L, TimeUnit.SECONDS));
        hazelcastInstance.shutdown();
        ClientRegressionWithMockNetworkTest.assertOpenEventually((String)"Put operations should not hang.", (CountDownLatch)testFinishedLatch);
    }

    @Test(timeout=120000L)
    public void testMemberAddedWithListeners_thenCheckOperationsNotHanging() {
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty(ClientExecutionServiceImpl.INTERNAL_EXECUTOR_POOL_SIZE.getName(), "1");
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        IMap map = client.getMap("map");
        map.addEntryListener((MapListener)Mockito.mock(MapListener.class), true);
        HazelcastInstance h2 = this.hazelcastFactory.newHazelcastInstance();
        String key = ClientRegressionWithMockNetworkTest.generateKeyOwnedBy((HazelcastInstance)h2);
        map.get((Object)key);
    }

    @Test
    @Category(value={SlowTest.class})
    public void testServerShouldNotCloseClientWhenClientOnlyListening() {
        Config config = new Config();
        int clientHeartbeatSeconds = 8;
        config.setProperty(GroupProperty.CLIENT_HEARTBEAT_TIMEOUT_SECONDS.getName(), String.valueOf(clientHeartbeatSeconds));
        this.hazelcastFactory.newHazelcastInstance(config);
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty(ClientProperty.HEARTBEAT_INTERVAL.getName(), "1000");
        HazelcastInstance client = this.hazelcastFactory.newHazelcastClient(clientConfig);
        HazelcastInstance client2 = this.hazelcastFactory.newHazelcastClient();
        final AtomicBoolean isClientDisconnected = new AtomicBoolean();
        client.getLifecycleService().addLifecycleListener(new LifecycleListener(){

            public void stateChanged(LifecycleEvent event) {
                if (LifecycleEvent.LifecycleState.CLIENT_DISCONNECTED.equals((Object)event.getState())) {
                    isClientDisconnected.set(true);
                }
            }
        });
        String key = "topicName";
        ITopic topic = client.getTopic(key);
        MessageListener listener = new MessageListener(){

            public void onMessage(Message message) {
            }
        };
        String id = topic.addMessageListener(listener);
        ITopic client2Topic = client2.getTopic(key);
        long begin = System.currentTimeMillis();
        while (System.currentTimeMillis() - begin < TimeUnit.SECONDS.toMillis(clientHeartbeatSeconds * 2)) {
            client2Topic.publish((Object)"message");
        }
        topic.removeMessageListener(id);
        Assert.assertFalse((boolean)isClientDisconnected.get());
    }

    public static class UnDeserializable
    implements DataSerializable {
        private int foo;

        public UnDeserializable(int foo) {
            this.foo = foo;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeInt(this.foo);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.foo = in.readInt();
        }
    }

    public static class Issue2509Runnable
    implements Callable<Integer>,
    DataSerializable {
        private UnDeserializable unDeserializable;

        public Issue2509Runnable() {
        }

        public Issue2509Runnable(UnDeserializable unDeserializable) {
            this.unDeserializable = unDeserializable;
        }

        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeObject((Object)this.unDeserializable);
        }

        public void readData(ObjectDataInput in) throws IOException {
            this.unDeserializable = (UnDeserializable)in.readObject();
        }

        @Override
        public Integer call() {
            return this.unDeserializable.foo;
        }
    }

    static class SamplePortable
    implements Portable {
        public int a;

        public SamplePortable(int a) {
            this.a = a;
        }

        public SamplePortable() {
        }

        public int getFactoryId() {
            return 5;
        }

        public int getClassId() {
            return 6;
        }

        public void writePortable(PortableWriter writer) throws IOException {
            writer.writeInt("a", this.a);
        }

        public void readPortable(PortableReader reader) throws IOException {
            this.a = reader.readInt("a");
        }
    }

    public static class MyCredentials
    extends UsernamePasswordCredentials {
        public MyCredentials() {
            super("foo", "bar");
        }
    }

    private static class MapInterceptorImpl
    implements MapInterceptor {
        MapInterceptorImpl() {
        }

        public Object interceptGet(Object value) {
            if ("value1".equals(value)) {
                return "getIntercepted";
            }
            return null;
        }

        public void afterGet(Object value) {
        }

        public Object interceptPut(Object oldValue, Object newValue) {
            if ("oldValue".equals(oldValue) && "newValue".equals(newValue)) {
                return "putIntercepted";
            }
            return null;
        }

        public void afterPut(Object value) {
        }

        public Object interceptRemove(Object removedValue) {
            if ("value2".equals(removedValue)) {
                return "removeIntercepted";
            }
            return null;
        }

        public void afterRemove(Object value) {
        }
    }
}

