/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.spi.properties.ClientProperty;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.OperationTimeoutException;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.QuickTest;
import java.io.Serializable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.junit.After;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class ClientTimeoutTest {
    @After
    public void cleanup() {
        Hazelcast.shutdownAll();
        HazelcastClient.shutdownAll();
    }

    @Test(timeout=20000L, expected=IllegalStateException.class)
    public void testTimeoutToOutsideNetwork() {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getGroupConfig().setName("dev").setPassword("dev-pass");
        ClientNetworkConfig networkConfig = clientConfig.getNetworkConfig();
        networkConfig.addAddress(new String[]{"8.8.8.8:5701"});
        networkConfig.setConnectionAttemptLimit(1);
        networkConfig.setConnectionTimeout(1000);
        HazelcastInstance client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        client.getList("test");
    }

    @Test
    public void testConnectionTimeout_withIntMax() {
        this.testConnectionTimeout(Integer.MAX_VALUE);
    }

    @Test
    public void testConnectionTimeout_withZeroValue() {
        this.testConnectionTimeout(0);
    }

    public void testConnectionTimeout(int timeoutInMillis) {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setConnectionTimeout(timeoutInMillis);
        Hazelcast.newHazelcastInstance();
        HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
    }

    @Test(expected=OperationTimeoutException.class)
    public void testInvocationTimeOut() throws Throwable {
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.setProperty(ClientProperty.INVOCATION_TIMEOUT_SECONDS.getName(), "0");
        Hazelcast.newHazelcastInstance();
        HazelcastInstance client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        IExecutorService executorService = client.getExecutorService("test");
        Future future = executorService.submit((Callable)new RetryableExceptionThrowingCallable());
        try {
            future.get();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (ExecutionException e) {
            throw e.getCause();
        }
    }

    public static class RetryableExceptionThrowingCallable
    implements Callable,
    Serializable {
        public Object call() throws Exception {
            throw new RetryableHazelcastException();
        }
    }
}

