/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.config.helpers.DeclarativeConfigFileHelper;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.instance.HazelcastInstanceFactory;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class HazelcastClientConfigResolutionTest {
    private static final String SYSPROP_NAME = "hazelcast.client.config";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private HazelcastInstance instance;
    private DeclarativeConfigFileHelper helper = new DeclarativeConfigFileHelper();

    @Before
    public void setUp() {
        System.clearProperty(SYSPROP_NAME);
    }

    @After
    public void tearDown() throws Exception {
        if (this.instance != null) {
            this.instance.shutdown();
        }
        System.clearProperty(SYSPROP_NAME);
        this.helper.ensureTestConfigDeleted();
    }

    @Test
    public void testResolveSystemProperty_file_xml_loadedAsXml() throws Exception {
        File file = this.helper.givenXmlClientConfigFileInWorkDir("foo.xml", "cluster-xml");
        System.setProperty(SYSPROP_NAME, file.getAbsolutePath());
        this.instance = HazelcastClient.newHazelcastClient();
        ClientConfig config = this.getClientConfig(this.instance);
        Assert.assertEquals((Object)"cluster-xml", (Object)config.getInstanceName());
    }

    @Test
    public void testResolveSystemProperty_classpath_xml_loadedAsXml() throws Exception {
        this.helper.givenXmlClientConfigFileOnClasspath("foo.xml", "cluster-xml");
        System.setProperty(SYSPROP_NAME, "classpath:foo.xml");
        this.instance = HazelcastClient.newHazelcastClient();
        ClientConfig config = this.getClientConfig(this.instance);
        Assert.assertEquals((Object)"cluster-xml", (Object)config.getInstanceName());
    }

    @Test
    public void testResolveSystemProperty_file_yaml_loadedAsYaml() throws Exception {
        HazelcastTestSupport.assumeThatJDK8OrHigher();
        File file = this.helper.givenYamlClientConfigFileInWorkDir("foo.yaml", "cluster-yaml");
        System.setProperty(SYSPROP_NAME, file.getAbsolutePath());
        this.instance = HazelcastClient.newHazelcastClient();
        ClientConfig config = this.getClientConfig(this.instance);
        Assert.assertEquals((Object)"cluster-yaml", (Object)config.getInstanceName());
    }

    @Test
    public void testResolveSystemProperty_classpath_yaml_loadedAsYaml() throws Exception {
        HazelcastTestSupport.assumeThatJDK8OrHigher();
        this.helper.givenYamlClientConfigFileOnClasspath("foo.yaml", "cluster-yaml");
        System.setProperty(SYSPROP_NAME, "classpath:foo.yaml");
        this.instance = HazelcastClient.newHazelcastClient();
        ClientConfig config = this.getClientConfig(this.instance);
        Assert.assertEquals((Object)"cluster-yaml", (Object)config.getInstanceName());
    }

    @Test
    public void testResolveSystemProperty_file_yml_loadedAsYaml() throws Exception {
        HazelcastTestSupport.assumeThatJDK8OrHigher();
        File file = this.helper.givenYamlClientConfigFileInWorkDir("foo.yml", "cluster-yaml");
        System.setProperty(SYSPROP_NAME, file.getAbsolutePath());
        this.instance = HazelcastClient.newHazelcastClient();
        ClientConfig config = this.getClientConfig(this.instance);
        Assert.assertEquals((Object)"cluster-yaml", (Object)config.getInstanceName());
    }

    @Test
    public void testResolveSystemProperty_classpath_yml_loadedAsYaml() throws Exception {
        HazelcastTestSupport.assumeThatJDK8OrHigher();
        this.helper.givenYamlClientConfigFileOnClasspath("foo.yml", "cluster-yaml");
        System.setProperty(SYSPROP_NAME, "classpath:foo.yml");
        this.instance = HazelcastClient.newHazelcastClient();
        ClientConfig config = this.getClientConfig(this.instance);
        Assert.assertEquals((Object)"cluster-yaml", (Object)config.getInstanceName());
    }

    @Test
    public void testResolveSystemProperty_file_bar_loadedAsXml() throws Exception {
        File file = this.helper.givenXmlClientConfigFileInWorkDir("foo.bar", "cluster-bar");
        System.setProperty(SYSPROP_NAME, file.getAbsolutePath());
        this.instance = HazelcastClient.newHazelcastClient();
        ClientConfig config = this.getClientConfig(this.instance);
        Assert.assertEquals((Object)"cluster-bar", (Object)config.getInstanceName());
    }

    @Test
    public void testResolveSystemProperty_classpath_bar_loadedAsXml() throws Exception {
        this.helper.givenXmlClientConfigFileOnClasspath("foo.bar", "cluster-bar");
        System.setProperty(SYSPROP_NAME, "classpath:foo.bar");
        this.instance = HazelcastClient.newHazelcastClient();
        ClientConfig config = this.getClientConfig(this.instance);
        Assert.assertEquals((Object)"cluster-bar", (Object)config.getInstanceName());
    }

    @Test
    public void testResolveSystemProperty_file_nonExistentXml_throws() {
        System.setProperty(SYSPROP_NAME, "foo.xml");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("foo.xml");
        this.instance = HazelcastClient.newHazelcastClient();
    }

    @Test
    public void testResolveSystemProperty_classpath_nonExistentXml_throws() {
        System.setProperty(SYSPROP_NAME, "classpath:foo.xml");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("classpath");
        this.expectedException.expectMessage("foo.xml");
        this.instance = HazelcastClient.newHazelcastClient();
    }

    @Test
    public void testResolveSystemProperty_file_nonExistentYaml_throws() {
        System.setProperty(SYSPROP_NAME, "foo.yaml");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("foo.yaml");
        this.instance = HazelcastClient.newHazelcastClient();
    }

    @Test
    public void testResolveSystemProperty_classpath_nonExistentYaml_throws() {
        System.setProperty(SYSPROP_NAME, "classpath:foo.yaml");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("classpath");
        this.expectedException.expectMessage("foo.yaml");
        this.instance = HazelcastClient.newHazelcastClient();
    }

    @Test
    public void testResolveSystemProperty_file_nonExistentYml_throws() {
        System.setProperty(SYSPROP_NAME, "foo.yml");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("foo.yml");
        this.instance = HazelcastClient.newHazelcastClient();
    }

    @Test
    public void testResolveSystemProperty_classpath_nonExistentYml_throws() {
        System.setProperty(SYSPROP_NAME, "classpath:foo.yml");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("classpath");
        this.expectedException.expectMessage("foo.yml");
        this.instance = HazelcastClient.newHazelcastClient();
    }

    @Test
    public void testResolveSystemProperty_file_nonExistentBar_throws() {
        System.setProperty(SYSPROP_NAME, "foo.bar");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("foo.bar");
        this.instance = HazelcastClient.newHazelcastClient();
    }

    @Test
    public void testResolveSystemProperty_classpath_nonExistentBar_throws() {
        System.setProperty(SYSPROP_NAME, "classpath:foo.bar");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("classpath");
        this.expectedException.expectMessage("foo.bar");
        this.instance = HazelcastClient.newHazelcastClient();
    }

    @Test
    public void testResolveWorkDir_xml() throws Exception {
        this.helper.givenXmlClientConfigFileInWorkDir("cluster-xml");
        this.instance = HazelcastClient.newHazelcastClient();
        ClientConfig config = this.getClientConfig(this.instance);
        Assert.assertEquals((Object)"cluster-xml", (Object)config.getInstanceName());
    }

    @Test
    public void testResolveClasspath_xml() throws Exception {
        this.helper.givenXmlClientConfigFileOnClasspath("cluster-xml");
        this.instance = HazelcastClient.newHazelcastClient();
        ClientConfig config = this.getClientConfig(this.instance);
        Assert.assertEquals((Object)"cluster-xml", (Object)config.getInstanceName());
    }

    @Test
    public void testResolveWorkDir_yaml() throws Exception {
        HazelcastTestSupport.assumeThatJDK8OrHigher();
        this.helper.givenYamlClientConfigFileInWorkDir("cluster-yaml");
        this.instance = HazelcastClient.newHazelcastClient();
        ClientConfig config = this.getClientConfig(this.instance);
        Assert.assertEquals((Object)"cluster-yaml", (Object)config.getInstanceName());
    }

    @Test
    public void testResolveClasspath_yaml() throws Exception {
        HazelcastTestSupport.assumeThatJDK8OrHigher();
        this.helper.givenYamlClientConfigFileOnClasspath("cluster-yaml");
        this.instance = HazelcastClient.newHazelcastClient();
        ClientConfig config = this.getClientConfig(this.instance);
        Assert.assertEquals((Object)"cluster-yaml", (Object)config.getInstanceName());
    }

    @Test
    public void testResolveDefault_xml() {
        HazelcastInstance member = HazelcastInstanceFactory.newHazelcastInstance(null);
        try {
            this.getClass().getClassLoader().getResource("hazelcast-client-default.xml");
            this.instance = HazelcastClient.newHazelcastClient();
            ClientConfig config = this.getClientConfig(this.instance);
            Assert.assertEquals((Object)"dev", (Object)config.getGroupConfig().getName());
        }
        finally {
            member.shutdown();
        }
    }

    private ClientConfig getClientConfig(HazelcastInstance instance) {
        return ((HazelcastClientProxy)instance).getClientConfig();
    }
}

