/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientFailoverConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientProxy;
import com.hazelcast.config.helpers.DeclarativeConfigFileHelper;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.QuickTest;
import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={QuickTest.class})
public class HazelcastClientFailoverConfigResolutionTest {
    private static final String SYSPROP_NAME = "hazelcast.client.failover.config";
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    private HazelcastInstance instance;
    private DeclarativeConfigFileHelper helper = new DeclarativeConfigFileHelper();

    @Before
    public void setUp() {
        System.clearProperty(SYSPROP_NAME);
    }

    @After
    public void tearDown() throws Exception {
        if (this.instance != null) {
            this.instance.shutdown();
        }
        System.clearProperty(SYSPROP_NAME);
        this.helper.ensureTestConfigDeleted();
    }

    @Test
    public void testResolveSystemProperty_file_xml_loadedAsXml() throws Exception {
        File file = this.helper.givenXmlClientFailoverConfigFileInWorkDir("foo.xml", 42);
        System.setProperty(SYSPROP_NAME, file.getAbsolutePath());
        this.instance = HazelcastClient.newHazelcastFailoverClient();
        ClientFailoverConfig config = this.getClientConfig(this.instance);
        Assert.assertEquals((long)42L, (long)config.getTryCount());
    }

    @Test
    public void testResolveSystemProperty_classpath_xml_loadedAsXml() throws Exception {
        this.helper.givenXmlClientFailoverConfigFileOnClasspath("foo.xml", 42);
        System.setProperty(SYSPROP_NAME, "classpath:foo.xml");
        this.instance = HazelcastClient.newHazelcastFailoverClient();
        ClientFailoverConfig config = this.getClientConfig(this.instance);
        Assert.assertEquals((long)42L, (long)config.getTryCount());
    }

    @Test
    public void testResolveSystemProperty_file_yaml_loadedAsYaml() throws Exception {
        HazelcastTestSupport.assumeThatJDK8OrHigher();
        File file = this.helper.givenYamlClientFailoverConfigFileInWorkDir("foo.yaml", 42);
        System.setProperty(SYSPROP_NAME, file.getAbsolutePath());
        this.instance = HazelcastClient.newHazelcastFailoverClient();
        ClientFailoverConfig config = this.getClientConfig(this.instance);
        Assert.assertEquals((long)42L, (long)config.getTryCount());
    }

    @Test
    public void testResolveSystemProperty_classpath_yaml_loadedAsYaml() throws Exception {
        HazelcastTestSupport.assumeThatJDK8OrHigher();
        this.helper.givenYamlClientFailoverConfigFileOnClasspath("foo.yaml", 42);
        System.setProperty(SYSPROP_NAME, "classpath:foo.yaml");
        this.instance = HazelcastClient.newHazelcastFailoverClient();
        ClientFailoverConfig config = this.getClientConfig(this.instance);
        Assert.assertEquals((long)42L, (long)config.getTryCount());
    }

    @Test
    public void testResolveSystemProperty_file_yml_loadedAsYaml() throws Exception {
        HazelcastTestSupport.assumeThatJDK8OrHigher();
        File file = this.helper.givenYamlClientFailoverConfigFileInWorkDir("foo.yml", 42);
        System.setProperty(SYSPROP_NAME, file.getAbsolutePath());
        this.instance = HazelcastClient.newHazelcastFailoverClient();
        ClientFailoverConfig config = this.getClientConfig(this.instance);
        Assert.assertEquals((long)42L, (long)config.getTryCount());
    }

    @Test
    public void testResolveSystemProperty_classpath_yml_loadedAsYaml() throws Exception {
        HazelcastTestSupport.assumeThatJDK8OrHigher();
        this.helper.givenYamlClientFailoverConfigFileOnClasspath("foo.yml", 42);
        System.setProperty(SYSPROP_NAME, "classpath:foo.yml");
        this.instance = HazelcastClient.newHazelcastFailoverClient();
        ClientFailoverConfig config = this.getClientConfig(this.instance);
        Assert.assertEquals((long)42L, (long)config.getTryCount());
    }

    @Test
    public void testResolveSystemProperty_file_bar_loadedAsXml() throws Exception {
        File file = this.helper.givenXmlClientFailoverConfigFileInWorkDir("foo.bar", 42);
        System.setProperty(SYSPROP_NAME, file.getAbsolutePath());
        this.instance = HazelcastClient.newHazelcastFailoverClient();
        ClientFailoverConfig config = this.getClientConfig(this.instance);
        Assert.assertEquals((long)42L, (long)config.getTryCount());
    }

    @Test
    public void testResolveSystemProperty_classpath_bar_loadedAsXml() throws Exception {
        this.helper.givenXmlClientFailoverConfigFileOnClasspath("foo.bar", 42);
        System.setProperty(SYSPROP_NAME, "classpath:foo.bar");
        this.instance = HazelcastClient.newHazelcastFailoverClient();
        ClientFailoverConfig config = this.getClientConfig(this.instance);
        Assert.assertEquals((long)42L, (long)config.getTryCount());
    }

    @Test
    public void testResolveSystemProperty_file_nonExistentXml_throws() {
        System.setProperty(SYSPROP_NAME, "foo.xml");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("foo.xml");
        this.instance = HazelcastClient.newHazelcastFailoverClient();
    }

    @Test
    public void testResolveSystemProperty_classpath_nonExistentXml_throws() {
        System.setProperty(SYSPROP_NAME, "classpath:foo.xml");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("classpath");
        this.expectedException.expectMessage("foo.xml");
        this.instance = HazelcastClient.newHazelcastFailoverClient();
    }

    @Test
    public void testResolveSystemProperty_file_nonExistentYaml_throws() {
        System.setProperty(SYSPROP_NAME, "foo.yaml");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("foo.yaml");
        this.instance = HazelcastClient.newHazelcastFailoverClient();
    }

    @Test
    public void testResolveSystemProperty_classpath_nonExistentYaml_throws() {
        System.setProperty(SYSPROP_NAME, "classpath:foo.yaml");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("classpath");
        this.expectedException.expectMessage("foo.yaml");
        this.instance = HazelcastClient.newHazelcastFailoverClient();
    }

    @Test
    public void testResolveSystemProperty_file_nonExistentYml_throws() {
        System.setProperty(SYSPROP_NAME, "foo.yml");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("foo.yml");
        this.instance = HazelcastClient.newHazelcastFailoverClient();
    }

    @Test
    public void testResolveSystemProperty_classpath_nonExistentYml_throws() {
        System.setProperty(SYSPROP_NAME, "classpath:foo.yml");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("classpath");
        this.expectedException.expectMessage("foo.yml");
        this.instance = HazelcastClient.newHazelcastFailoverClient();
    }

    @Test
    public void testResolveSystemProperty_file_nonExistentBar_throws() {
        System.setProperty(SYSPROP_NAME, "foo.bar");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("foo.bar");
        this.instance = HazelcastClient.newHazelcastFailoverClient();
    }

    @Test
    public void testResolveSystemProperty_classpath_nonExistentBar_throws() {
        System.setProperty(SYSPROP_NAME, "classpath:foo.bar");
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("classpath");
        this.expectedException.expectMessage("foo.bar");
        this.instance = HazelcastClient.newHazelcastFailoverClient();
    }

    @Test
    public void testResolveWorkDir_xml() throws Exception {
        this.helper.givenXmlClientFailoverConfigFileInWorkDir(42);
        this.instance = HazelcastClient.newHazelcastFailoverClient();
        ClientFailoverConfig config = this.getClientConfig(this.instance);
        Assert.assertEquals((long)42L, (long)config.getTryCount());
    }

    @Test
    public void testResolveClasspath_xml() throws Exception {
        this.helper.givenXmlClientFailoverConfigFileOnClasspath(42);
        this.instance = HazelcastClient.newHazelcastFailoverClient();
        ClientFailoverConfig config = this.getClientConfig(this.instance);
        Assert.assertEquals((long)42L, (long)config.getTryCount());
    }

    @Test
    public void testResolveWorkDir_yaml() throws Exception {
        HazelcastTestSupport.assumeThatJDK8OrHigher();
        this.helper.givenYamlClientFailoverConfigFileInWorkDir(42);
        this.instance = HazelcastClient.newHazelcastFailoverClient();
        ClientFailoverConfig config = this.getClientConfig(this.instance);
        Assert.assertEquals((long)42L, (long)config.getTryCount());
    }

    @Test
    public void testResolveClasspath_yaml() throws Exception {
        HazelcastTestSupport.assumeThatJDK8OrHigher();
        this.helper.givenYamlClientFailoverConfigFileOnClasspath(42);
        this.instance = HazelcastClient.newHazelcastFailoverClient();
        ClientFailoverConfig config = this.getClientConfig(this.instance);
        Assert.assertEquals((long)42L, (long)config.getTryCount());
    }

    @Test
    public void testResolveDefault_xml() {
        this.expectedException.expect(HazelcastException.class);
        this.expectedException.expectMessage("Failed to load ClientFailoverConfig");
        this.instance = HazelcastClient.newHazelcastFailoverClient();
    }

    private ClientFailoverConfig getClientConfig(HazelcastInstance instance) {
        return ((HazelcastClientProxy)instance).client.getFailoverConfig();
    }
}

