/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.HazelcastTestSupport;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.HashMap;
import java.util.Map;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class NonSmartClientRoutingTest {
    private final TestHazelcastFactory hazelcastFactory = new TestHazelcastFactory();
    private HazelcastInstance client;
    private HazelcastInstance server1;

    @After
    public void tearDown() {
        this.hazelcastFactory.terminateAll();
    }

    @Before
    public void setup() {
        this.server1 = this.hazelcastFactory.newHazelcastInstance();
        this.hazelcastFactory.newHazelcastInstance();
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.getNetworkConfig().setSmartRouting(false);
        this.client = this.hazelcastFactory.newHazelcastClient(clientConfig);
    }

    @Test
    public void test() {
        String mapName = HazelcastTestSupport.randomString();
        HashMap<String, String> origin = new HashMap<String, String>();
        for (int k = 0; k < 1000; ++k) {
            String value = HazelcastTestSupport.randomString();
            origin.put(value, value);
        }
        this.server1.getMap(mapName).putAll(origin);
        IMap map = this.client.getMap(mapName);
        for (Map.Entry entry : origin.entrySet()) {
            String key = (String)entry.getKey();
            String expectedValue = (String)map.get((Object)key);
            String actualValue = (String)map.get((Object)key);
            Assert.assertEquals((Object)expectedValue, (Object)actualValue);
        }
    }
}

