/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.HazelcastClient;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.spi.properties.GroupProperty;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;
import org.junit.Ignore;

@Ignore(value="Not a JUnit test")
public class SimpleMapTestFromClient {
    private static int threadCount;
    private static int entryCount;
    private static int valueSize;
    private static int statsSeconds;
    private static int getPercentage;
    private static int putPercentage;

    public static void main(String[] args) {
        ClientConfig clientConfig = new ClientConfig();
        Hazelcast.newHazelcastInstance();
        Hazelcast.newHazelcastInstance();
        final HazelcastInstance client = HazelcastClient.newHazelcastClient((ClientConfig)clientConfig);
        final Stats stats = new Stats();
        if (args != null && args.length > 0) {
            for (String arg : args) {
                if ((arg = arg.trim()).startsWith("t")) {
                    threadCount = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (arg.startsWith("c")) {
                    entryCount = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (arg.startsWith("v")) {
                    valueSize = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (arg.startsWith("g")) {
                    getPercentage = Integer.parseInt(arg.substring(1));
                    continue;
                }
                if (!arg.startsWith("p")) continue;
                putPercentage = Integer.parseInt(arg.substring(1));
            }
        } else {
            System.out.println("Help: sh test.sh t200 v130 p10 g85 ");
            System.out.println("    // means 200 threads, value-size 130 bytes, 10% put, 85% get");
            System.out.println("");
        }
        System.out.println("Starting Test with ");
        System.out.println("      Thread Count: " + threadCount);
        System.out.println("       Entry Count: " + entryCount);
        System.out.println("        Value Size: " + valueSize);
        System.out.println("    Get Percentage: " + getPercentage);
        System.out.println("    Put Percentage: " + putPercentage);
        System.out.println(" Remove Percentage: " + (100 - (putPercentage + getPercentage)));
        ExecutorService es = Executors.newFixedThreadPool(threadCount);
        for (int i = 0; i < threadCount; ++i) {
            es.submit(new Runnable(){

                @Override
                public void run() {
                    IMap map = client.getMap("default");
                    while (true) {
                        int key = (int)(Math.random() * (double)entryCount);
                        int operation = (int)(Math.random() * 100.0);
                        if (operation < getPercentage) {
                            map.get((Object)String.valueOf(key));
                            stats.gets.incrementAndGet();
                            continue;
                        }
                        if (operation < getPercentage + putPercentage) {
                            map.put((Object)String.valueOf(key), (Object)new byte[valueSize]);
                            stats.puts.incrementAndGet();
                            continue;
                        }
                        map.remove((Object)String.valueOf(key));
                        stats.removes.incrementAndGet();
                    }
                }
            });
        }
        Executors.newSingleThreadExecutor().submit(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            Thread.sleep(statsSeconds * 1000);
                            System.out.println("cluster size:" + client.getCluster().getMembers().size());
                            Stats currentStats = stats.getAndReset();
                            System.out.println(currentStats);
                            System.out.println("Operations per Second: " + currentStats.total() / (long)statsSeconds);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
    }

    static {
        GroupProperty.WAIT_SECONDS_BEFORE_JOIN.setSystemProperty("0");
        System.setProperty("java.net.preferIPv4Stack", "true");
        System.setProperty("hazelcast.local.localAddress", "127.0.0.1");
        GroupProperty.PHONE_HOME_ENABLED.setSystemProperty("false");
        GroupProperty.SOCKET_BIND_ANY.setSystemProperty("false");
        threadCount = 40;
        entryCount = 10000;
        valueSize = 1000;
        statsSeconds = 10;
        getPercentage = 40;
        putPercentage = 40;
    }

    public static class Stats {
        public AtomicLong puts = new AtomicLong();
        public AtomicLong gets = new AtomicLong();
        public AtomicLong removes = new AtomicLong();

        public Stats getAndReset() {
            long putsNow = this.puts.getAndSet(0L);
            long getsNow = this.gets.getAndSet(0L);
            long removesNow = this.removes.getAndSet(0L);
            Stats newOne = new Stats();
            newOne.puts.set(putsNow);
            newOne.gets.set(getsNow);
            newOne.removes.set(removesNow);
            return newOne;
        }

        public long total() {
            return this.puts.get() + this.gets.get() + this.removes.get();
        }

        public String toString() {
            return "total= " + this.total() + ", gets:" + this.gets.get() + ", puts: " + this.puts.get() + ", removes:" + this.removes.get();
        }
    }
}

