/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.aggregation;

import com.hazelcast.aggregation.MapAggregateTest;
import com.hazelcast.client.test.TestHazelcastFactory;
import com.hazelcast.config.Config;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IMap;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.After;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelTest.class})
public class ClientMapAggregateTest
extends MapAggregateTest {
    private TestHazelcastFactory factory;
    private HazelcastInstance client;

    @After
    public void tearDown() {
        this.factory.shutdownAll();
    }

    public <K, V> IMap<K, V> getMapWithNodeCount(int nodeCount) {
        if (nodeCount < 1) {
            throw new IllegalArgumentException("node count < 1");
        }
        this.factory = new TestHazelcastFactory();
        Config config = new Config();
        config.setProperty("hazelcast.partition.count", "3");
        MapConfig mapConfig = new MapConfig();
        mapConfig.setName("aggr");
        mapConfig.setInMemoryFormat(InMemoryFormat.OBJECT);
        config.addMapConfig(mapConfig);
        this.factory.newInstances(config, nodeCount);
        this.client = this.factory.newHazelcastClient();
        return this.client.getMap("aggr");
    }
}

